/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class AbstractBrowserTestBase {
    protected HgBrowser browser;
    protected MercurialChangeSet changeSet;

    AbstractBrowserTestBase() {
    }

    @BeforeEach
    void beforeEach() throws Exception {
        this.browser = this.getBrowser();
        this.changeSet = new MercurialChangeSet();
        this.changeSet.setNode("6704efde87541766fadba17f66d04b926cd4d343");
    }

    protected abstract HgBrowser getBrowser() throws Exception;

    @Test
    void testGetFileLinkIllegalState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.browser.getFileLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java"));
    }

    @Test
    void testGetDiffLinkIllegalState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.browser.getDiffLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java"));
    }

    protected void testGetFileLink(String expected) throws Exception {
        this.browser.getChangeSetLink(this.changeSet);
        Assertions.assertEquals((Object)expected, (Object)this.browser.getFileLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java").toExternalForm());
    }

    protected void testGetDiffLink(String expected) throws Exception {
        this.browser.getChangeSetLink(this.changeSet);
        Assertions.assertEquals((Object)expected, (Object)this.browser.getDiffLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java").toExternalForm());
    }

    protected void testGetChangeSetLinkMercurialChangeSet(String expected) throws Exception {
        Assertions.assertEquals((Object)expected, (Object)this.browser.getChangeSetLink(this.changeSet).toExternalForm());
    }
}

