/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.scm.PollingResult;
import hudson.triggers.SCMTrigger;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamTaskListener;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.jvnet.hudson.test.JenkinsRule;
import org.opentest4j.TestAbortedException;

public class MercurialTestUtil {
    private final TaskListener listener = new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset());
    private boolean validated;
    private final JenkinsRule j;
    private Node node;
    private MercurialInstallation inst;

    public MercurialTestUtil(JenkinsRule j) {
        this.j = j;
    }

    public MercurialTestUtil withNode(Node node) {
        this.node = node;
        return this;
    }

    public MercurialTestUtil withInstallation(MercurialInstallation inst) {
        this.inst = inst;
        return this;
    }

    private Node node() {
        return this.node != null ? this.node : this.j.jenkins;
    }

    private Launcher launcher() {
        return this.node().createLauncher(this.listener);
    }

    private HgExe hgExe() throws Exception {
        return this.hgExe(new EnvVars());
    }

    private HgExe hgExe(EnvVars env) throws Exception {
        HgExe hg = new HgExe(this.inst, null, this.launcher(), this.node(), this.listener, env);
        if (!this.validated) {
            try {
                String version = hg.version();
                Assumptions.assumeTrue((version != null ? 1 : 0) != 0);
                System.out.println("Mercurial version detected: " + version);
                Assumptions.assumeFalse((boolean)new VersionNumber(version).isOlderThan(new VersionNumber(MercurialContainer.Version.HG6.exactVersion)), (String)(version + " is too old to even test"));
            }
            catch (IOException ioe) {
                String message = ioe.getMessage();
                if (message.startsWith("Cannot run program \"hg\"") && message.endsWith("No such file or directory")) {
                    throw new TestAbortedException("hg is not available; please check that your PATH environment variable is properly configured");
                }
                throw new TestAbortedException(ioe.toString());
            }
            this.validated = true;
        }
        return hg;
    }

    public void hg(String ... args) throws Exception {
        HgExe hg = this.hgExe();
        Assertions.assertEquals((int)0, (int)hg.launch(MercurialTestUtil.nobody(hg.seed(false)).add(args)).join());
    }

    @Deprecated
    public void hg(File repo, String ... args) throws Exception {
        this.hg(new FilePath(repo), args);
    }

    public void hg(FilePath repo, String ... args) throws Exception {
        HgExe hg = this.hgExe();
        Assertions.assertEquals((int)0, (int)hg.launch(MercurialTestUtil.nobody(hg.seed(false)).add(args)).pwd(repo).join());
    }

    @Deprecated
    public void hg(File repo, EnvVars env, String ... args) throws Exception {
        this.hg(new FilePath(repo), env, args);
    }

    public void hg(FilePath repo, EnvVars env, String ... args) throws Exception {
        HgExe hg = this.hgExe(env);
        Assertions.assertEquals((int)0, (int)hg.launch(MercurialTestUtil.nobody(hg.seed(false)).add(args)).envs((Map)env).pwd(repo.child(env.expand(repo.getRemote()))).join());
    }

    private static ArgumentListBuilder nobody(ArgumentListBuilder args) {
        return args.add("--config").add("ui.username=nobody@nowhere.net");
    }

    @Deprecated
    public void touchAndCommit(File repo, String ... names) throws Exception {
        this.touchAndCommit(new FilePath(repo), names);
    }

    public void touchAndCommit(FilePath repo, String ... names) throws Exception {
        for (String name : names) {
            FilePath toTouch = repo.child(name);
            if (!toTouch.exists()) {
                toTouch.getParent().mkdirs();
                toTouch.touch(0L);
                this.hg(repo, "add", name);
                continue;
            }
            toTouch.write(toTouch.readToString() + "extra line\n", "UTF-8");
        }
        this.hg(repo, "commit", "--message", "added " + Arrays.toString(names));
    }

    public String buildAndCheck(FreeStyleProject p, String name, Action ... actions) throws Exception {
        FreeStyleBuild b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Run)((FreeStyleBuild)p.scheduleBuild2(0, null, actions).get()));
        if (!b.getWorkspace().child(name).exists()) {
            TreeSet<String> children = new TreeSet<String>();
            for (FilePath child : b.getWorkspace().list()) {
                children.add(child.getName());
            }
            Assertions.fail((String)("Could not find " + name + " among " + String.valueOf(children)));
        }
        Assertions.assertNotNull((Object)b.getAction(MercurialTagAction.class));
        String log = b.getLog();
        return log;
    }

    public PollingResult pollSCMChanges(FreeStyleProject p) {
        return p.poll((TaskListener)new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset()));
    }

    @Deprecated
    public String getLastChangesetId(File repo) throws Exception {
        return this.getLastChangesetId(new FilePath(repo));
    }

    public String getLastChangesetId(FilePath repo) throws Exception {
        return this.hgExe().popen(repo, this.listener, false, new ArgumentListBuilder(new String[]{"log", "-l1", "--template", "{node}"}));
    }

    @Deprecated
    public long getLastChangesetUnixTimestamp(File repo) throws Exception {
        return this.getLastChangesetUnixTimestamp(new FilePath(repo));
    }

    public long getLastChangesetUnixTimestamp(FilePath repo) throws Exception {
        String date = this.hgExe().popen(repo, this.listener, false, new ArgumentListBuilder(new String[]{"log", "-l1", "--template", "{date|hgdate}"}));
        return Long.parseLong(date.split(" ")[0]);
    }

    public void notifyCommit(FilePath repo) throws Exception {
        ((SCMTrigger.DescriptorImpl)this.j.jenkins.getDescriptorByType(SCMTrigger.DescriptorImpl.class)).synchronousPolling = true;
        System.out.println(this.j.createWebClient().goTo("mercurial/notifyCommit?url=" + repo.toURI().toString(), "text/plain").getWebResponse().getContentAsString());
        this.j.waitUntilNoActivity();
    }

    public void registerHook(FilePath repo) throws Exception {
        assert (!repo.isRemote()) : "TODO not currently supported for remote repositories since the callback URL would not be accessible from the Docker container unless we do some more exotic network configuration";
        FilePath hgDir = repo.child(".hg");
        FilePath enforcePython3 = hgDir.child("enforce-python3.py");
        enforcePython3.write("import urllib.request, urllib.parse\ndef precommit(**kwargs):\n    urllib.request.Request('http://nowhere.net/')\n", null);
        FilePath hook = hgDir.child("hook.py");
        String hook_text = IOUtils.toString((InputStream)MercurialTestUtil.class.getResourceAsStream("/hook.py"), (Charset)StandardCharsets.UTF_8);
        hook_text = Strings.CS.replace(hook_text, "@JENKINS_URL@", this.j.getURL().toString());
        hook_text = Strings.CS.replace(hook_text, "@REPO_URL@", repo.toURI().toString());
        hook.write(hook_text, null);
        hgDir.child("hgrc").write("[hooks]\nprecommit.enforce-python3 = python:" + enforcePython3.getRemote() + ":precommit\ncommit.jenkins = python:" + hook.getRemote() + ":commit", null);
    }
}

