/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.plugins.mercurial.PipelineTest;
import hudson.plugins.mercurial.traits.MercurialInstallationSCMSourceTrait;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import jenkins.branch.BranchSource;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
@WithJenkins
class MercurialSCMSource2Test {
    private static String noSpaceInTmpDirs;
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER;
    private JenkinsRule r;
    private MercurialTestUtil m;
    @Container
    private static final MercurialContainer container;
    @TempDir
    private File tmp;

    MercurialSCMSource2Test() {
    }

    @BeforeAll
    static void beforeAll() {
        noSpaceInTmpDirs = System.setProperty("jenkins.test.noSpaceInTmpDirs", "true");
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
        this.m = new MercurialTestUtil(this.r);
    }

    @AfterAll
    static void afterAll() {
        if (noSpaceInTmpDirs != null) {
            System.setProperty("jenkins.test.noSpaceInTmpDirs", noSpaceInTmpDirs);
        } else {
            System.clearProperty("jenkins.test.noSpaceInTmpDirs");
        }
    }

    @Test
    void withCredentialsId() throws Exception {
        this.m.hg("version");
        Slave agent = container.createAgent(this.r);
        this.m.withNode((Node)agent);
        MercurialInstallation inst = container.createInstallation(this.r, MercurialContainer.Version.HG6, false, false, false, "", agent);
        Assertions.assertNotNull((Object)inst);
        this.m.withInstallation(inst);
        FilePath sampleRepo = agent.getRootPath().child("sampleRepo");
        sampleRepo.mkdirs();
        this.m.hg(sampleRepo, "init");
        sampleRepo.child("Jenkinsfile").write("node('master') {checkout scm}", null);
        this.m.hg(sampleRepo, "commit", "--addremove", "--message=flow");
        MercurialSCMSource s = new MercurialSCMSource("ssh://test@" + container.getHost() + ":" + container.getMappedPort(22) + "/" + String.valueOf(sampleRepo));
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, "creds", "test", (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.FileOnMasterPrivateKeySource(container.getPrivateKey().getAbsolutePath()), null, null));
        s.setCredentialsId("creds");
        String toolHome = inst.forNode((Node)agent, (TaskListener)StreamTaskListener.fromStdout()).getHome();
        Assertions.assertNotNull((Object)toolHome);
        String remoteHgLoc = inst.executableWithSubstitution(toolHome);
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("default", "", "hg", false, true, null, false, "[ui]\nssh = ssh -o UserKnownHostsFile=" + String.valueOf(MercurialSCMSource2Test.newFile(this.tmp, "known_hosts")) + " -o StrictHostKeyChecking=no\nremotecmd = " + remoteHgLoc, null)});
        s.setTraits(Collections.singletonList(new MercurialInstallationSCMSourceTrait("default")));
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)s));
        WorkflowJob p = PipelineTest.scheduleAndFindBranchProject(mp, "default");
        Assertions.assertEquals((int)1, (int)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b = p.getLastBuild();
        Assertions.assertNotNull((Object)b);
        this.r.assertBuildStatusSuccess((Run)b);
        Assertions.assertNotNull((Object)s.fetch("default", (TaskListener)StreamTaskListener.fromStderr(), (Item)p));
        sampleRepo.deleteRecursive();
        Assertions.assertEquals((Object)p, (Object)PipelineTest.scheduleAndFindBranchProject(mp, "default"));
    }

    private static File newFile(File parent, String child) throws IOException {
        File result = new File(parent, child);
        result.createNewFile();
        return result;
    }

    static {
        BUILD_WATCHER = new BuildWatcherExtension();
        container = new MercurialContainer();
    }
}

