/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMBuilder;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.MercurialSCMSourceContext;
import hudson.plugins.mercurial.traits.Messages;
import hudson.scm.SCM;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class MercurialInstallationSCMSourceTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String installation;

    @DataBoundConstructor
    public MercurialInstallationSCMSourceTrait(@CheckForNull String installation) {
        this.installation = Util.fixEmpty((String)installation);
    }

    @CheckForNull
    public String getInstallation() {
        return this.installation;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        ((MercurialSCMSourceContext)context).withInstallation(this.installation);
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((MercurialSCMBuilder)builder).withInstallation(this.installation);
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.MercurialInstallationSCMSourceTrait_displayName();
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return MercurialSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return MercurialSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return MercurialSCMSource.class;
        }

        public Class<? extends SCM> getScmClass() {
            return MercurialSCM.class;
        }

        public boolean isApplicableToBuilder(@NonNull Class<? extends SCMBuilder> builderClass) {
            if (super.isApplicableToBuilder(builderClass)) {
                for (MercurialInstallation i : MercurialInstallation.allInstallations()) {
                    if (!i.isUseCaches()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isApplicableToContext(@NonNull Class<? extends SCMSourceContext> contextClass) {
            if (super.isApplicableToContext(contextClass)) {
                for (MercurialInstallation i : MercurialInstallation.allInstallations()) {
                    if (!i.isUseCaches()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isApplicableToSCM(@NonNull Class<? extends SCM> scmClass) {
            if (super.isApplicableToSCM(scmClass)) {
                for (MercurialInstallation i : MercurialInstallation.allInstallations()) {
                    if (!i.isUseCaches()) continue;
                    return true;
                }
            }
            return false;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillInstallationItems(@AncestorInPath Item context) {
            ListBoxModel result = new ListBoxModel();
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ)) {
                return result;
            }
            for (MercurialInstallation i : MercurialInstallation.allInstallations()) {
                if (!i.isUseCaches()) continue;
                result.add(i.getName());
            }
            return result;
        }
    }
}

