/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.ChangeLogSet;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMEvents;
import jenkins.scm.api.SCMSource;
import jenkins.util.VirtualFile;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.opentest4j.TestAbortedException;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
@WithJenkins
class PipelineTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private JenkinsRule r;
    private MercurialTestUtil m;
    @Container
    private static final MercurialContainer container = new MercurialContainer();
    @TempDir
    private File tmp;

    PipelineTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
        this.m = new MercurialTestUtil(this.r);
    }

    @Test
    void multipleSCMs() throws Exception {
        Slave agent = container.createAgent(this.r);
        this.m.withNode((Node)agent);
        MercurialInstallation inst = container.createInstallation(this.r, MercurialContainer.Version.HG6, false, false, false, "", agent);
        Assertions.assertNotNull((Object)inst);
        this.m.withInstallation(inst);
        FilePath sampleRepo = agent.getRootPath().child("sampleRepo");
        sampleRepo.mkdirs();
        this.m.hg(sampleRepo, "init");
        this.m.touchAndCommit(sampleRepo, "file");
        FilePath otherRepo = agent.getRootPath().child("otherRepo");
        otherRepo.mkdirs();
        this.m.hg(otherRepo, "init");
        this.m.touchAndCommit(otherRepo, "otherfile");
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setQuietPeriod(Integer.valueOf(3));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node('" + agent.getNodeName() + "') {\n    dir('main') {\n        checkout([$class: 'MercurialSCM', source: $/" + String.valueOf(sampleRepo.toURI()) + "/$, installation: '" + inst.getName() + "'])\n    }\n    dir('other') {\n        checkout([$class: 'MercurialSCM', source: $/" + String.valueOf(otherRepo.toURI()) + "/$, installation: '" + inst.getName() + "', clean: true])\n        if (fileExists('unversioned')) {\n            error 'unversioned did exist'\n        } else {\n            echo 'unversioned did not exist'\n        }\n        writeFile text: '', file: 'unversioned'\n    }\n    archive '**'\n}"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        VirtualFile artifacts = b.getArtifactManager().root();
        Assertions.assertTrue((boolean)artifacts.child("main/file").isFile());
        Assertions.assertTrue((boolean)artifacts.child("other/otherfile").isFile());
        this.r.assertLogContains("unversioned did not exist", (Run)b);
        this.m.touchAndCommit(sampleRepo, "file2");
        this.m.touchAndCommit(otherRepo, "otherfile2");
        this.m.notifyCommit(sampleRepo);
        this.m.notifyCommit(otherRepo);
        FileUtils.copyFile((File)p.getSCMTrigger().getLogFile(), (OutputStream)System.out);
        b = (WorkflowRun)this.r.assertBuildStatusSuccess((Run)p.getLastBuild());
        Assertions.assertEquals((int)2, (int)b.number);
        artifacts = b.getArtifactManager().root();
        Assertions.assertTrue((boolean)artifacts.child("main/file2").isFile());
        Assertions.assertTrue((boolean)artifacts.child("other/otherfile2").isFile());
        this.r.assertLogContains("unversioned did not exist", (Run)b);
        Iterator scms = p.getSCMs().iterator();
        Assertions.assertTrue((boolean)scms.hasNext());
        Assertions.assertEquals((Object)sampleRepo.toURI().toString(), (Object)((MercurialSCM)scms.next()).getSource());
        Assertions.assertTrue((boolean)scms.hasNext());
        Assertions.assertEquals((Object)otherRepo.toURI().toString(), (Object)((MercurialSCM)scms.next()).getSource());
        Assertions.assertFalse((boolean)scms.hasNext());
        List changeSets = b.getChangeSets();
        Assertions.assertEquals((int)2, (int)changeSets.size());
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assertions.assertEquals((Object)b, (Object)changeSet.getRun());
        Assertions.assertEquals((Object)"hg", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assertions.assertEquals((Object)"[file2]", (Object)entry.getAffectedPaths().toString());
        Assertions.assertFalse((boolean)iterator.hasNext());
        changeSet = (ChangeLogSet)changeSets.get(1);
        iterator = changeSet.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        entry = (ChangeLogSet.Entry)iterator.next();
        Assertions.assertEquals((Object)"[otherfile2]", (Object)entry.getAffectedPaths().toString());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void exactRevisionMercurial() throws Exception {
        FilePath sampleRepo = new FilePath(this.tmp);
        this.m.hg(sampleRepo, "init");
        ScriptApproval sa = ScriptApproval.get();
        sa.approveSignature("staticField hudson.model.Items XSTREAM2");
        sa.approveSignature("method com.thoughtworks.xstream.XStream toXML java.lang.Object");
        sampleRepo.child("Jenkinsfile").write("echo hudson.model.Items.XSTREAM2.toXML(scm); semaphore 'wait'; node {checkout scm; echo readFile('file')}", null);
        sampleRepo.child("file").write("initial content", null);
        this.m.hg(sampleRepo, "commit", "--addremove", "--message=flow");
        this.m.hg(sampleRepo, "update", "null");
        this.m.hg(sampleRepo, "branch", "docs");
        sampleRepo.child("README").write("Just docs here!", null);
        this.m.hg(sampleRepo, "commit", "--message=unrelated branch, not buildable");
        this.m.hg(sampleRepo, "update", "default");
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        String instName = "caching";
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(instName, "", "hg", false, true, false, null, null)});
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new MercurialSCMSource(null, instName, sampleRepo.toURI().toString(), null, null, null, null, null, true)));
        WorkflowJob p = PipelineTest.scheduleAndFindBranchProject(mp, "default");
        Assertions.assertEquals((int)1, (int)mp.getItems().size());
        SemaphoreStep.waitForStart((String)"wait/1", null);
        WorkflowRun b1 = p.getLastBuild();
        Assertions.assertNotNull((Object)b1);
        Assertions.assertEquals((int)1, (int)b1.getNumber());
        sampleRepo.child("Jenkinsfile").write("node {checkout scm; echo readFile('file').toUpperCase()}", null);
        sampleRepo.child("file").write("subsequent content", null);
        this.m.hg(sampleRepo, "commit", "--message=tweaked");
        SemaphoreStep.success((String)"wait/1", null);
        this.m.notifyCommit(sampleRepo);
        PipelineTest.showIndexing(mp);
        WorkflowRun b2 = p.getLastBuild();
        Assertions.assertEquals((int)2, (int)b2.getNumber());
        this.r.assertLogContains("initial content", this.r.assertBuildStatusSuccess((Run)b1));
        this.r.assertLogContains("SUBSEQUENT CONTENT", this.r.assertBuildStatusSuccess((Run)b2));
        List changeSets = b2.getChangeSets();
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assertions.assertEquals((Object)b2, (Object)changeSet.getRun());
        Assertions.assertEquals((Object)"hg", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assertions.assertEquals((Object)"tweaked", (Object)entry.getMsg());
        Assertions.assertEquals((Object)"[Jenkinsfile, file]", (Object)new TreeSet(entry.getAffectedPaths()).toString());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void modernHook() throws Exception {
        String version;
        String instName = "caching";
        MercurialInstallation installation = new MercurialInstallation(instName, "", "hg", false, true, false, null, null);
        LogTaskListener listener = new LogTaskListener(Logger.getLogger(this.getClass().getName()), Level.INFO);
        HgExe hg = new HgExe(installation, null, this.r.jenkins.createLauncher((TaskListener)listener), (Node)this.r.jenkins, (TaskListener)listener, new EnvVars());
        try {
            version = hg.version();
        }
        catch (Exception x) {
            throw new TestAbortedException("cannot run hg version; perhaps not installed locally", (Throwable)x);
        }
        Assumptions.assumeTrue((boolean)new VersionNumber(version).isNewerThan(new VersionNumber("3.0")), (String)("Need mercurial 3.0ish to have in-process hooks, have " + version));
        FilePath sampleRepo = new FilePath(this.tmp);
        this.m.hg(sampleRepo, "init");
        sampleRepo.child("Jenkinsfile").write("node {checkout scm; echo readFile('file')}", null);
        sampleRepo.child("file").write("initial content", null);
        this.m.hg(sampleRepo, "commit", "--addremove", "--message=flow");
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{installation});
        installation.forNode((Node)this.r.jenkins, (TaskListener)StreamTaskListener.fromStdout());
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new MercurialSCMSource(null, instName, sampleRepo.toURI().toString(), null, null, null, null, null, true)));
        WorkflowJob p = PipelineTest.scheduleAndFindBranchProject(mp, "default");
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assertions.assertNotNull((Object)b1);
        Assertions.assertEquals((int)1, (int)b1.getNumber());
        long watermark = SCMEvents.getWatermark();
        this.m.registerHook(sampleRepo);
        sampleRepo.child("Jenkinsfile").write("node {checkout scm; echo readFile('file').toUpperCase()}", null);
        sampleRepo.child("file").write("subsequent content", null);
        try {
            this.m.hg(sampleRepo, "commit", "--message=tweaked");
        }
        catch (AssertionError x) {
            throw new TestAbortedException("probably using Python 2", (Throwable)((Object)x));
        }
        SCMEvents.awaitAll((long)watermark, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.r.jenkins.getQueue().maintain();
        PipelineTest.showEvents(mp);
        this.r.waitUntilNoActivity();
        WorkflowRun b2 = p.getLastBuild();
        Assertions.assertEquals((int)2, (int)b2.getNumber());
        this.r.assertLogContains("initial content", this.r.assertBuildStatusSuccess((Run)b1));
        this.r.assertLogContains("SUBSEQUENT CONTENT", this.r.assertBuildStatusSuccess((Run)b2));
        List changeSets = b2.getChangeSets();
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assertions.assertEquals((Object)b2, (Object)changeSet.getRun());
        Assertions.assertEquals((Object)"hg", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assertions.assertEquals((Object)"tweaked", (Object)entry.getMsg());
        Assertions.assertEquals((Object)"[Jenkinsfile, file]", (Object)new TreeSet(entry.getAffectedPaths()).toString());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @NonNull
    public static WorkflowJob scheduleAndFindBranchProject(@NonNull WorkflowMultiBranchProject mp, @NonNull String name) throws Exception {
        mp.scheduleBuild2(0, new Action[0]).getFuture().get();
        return PipelineTest.findBranchProject(mp, name);
    }

    @NonNull
    public static WorkflowJob findBranchProject(@NonNull WorkflowMultiBranchProject mp, @NonNull String name) throws Exception {
        WorkflowJob p = (WorkflowJob)mp.getItem(name);
        PipelineTest.showIndexing(mp);
        if (p == null) {
            Assertions.fail((String)(name + " project not found"));
        }
        return p;
    }

    static void showIndexing(@NonNull WorkflowMultiBranchProject mp) throws Exception {
        MultiBranchProject.BranchIndexing indexing = mp.getIndexing();
        System.out.println("---%<--- " + indexing.getUrl());
        indexing.writeWholeLogTo((OutputStream)System.out);
        System.out.println("---%<--- ");
    }

    static void showEvents(@NonNull WorkflowMultiBranchProject mp) throws Exception {
        AnnotatedLargeText events = mp.getComputation().getEventsText();
        System.out.println("---%<--- " + mp.getComputation().getUrl() + " EVENTS");
        events.writeLogTo(0L, (OutputStream)System.out);
        System.out.println("---%<--- ");
    }
}

