/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.plugins.mercurial.MercurialStatus;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MercurialStatusTest {
    MercurialStatusTest() {
    }

    @Test
    void testLooselyMatches() throws URISyntaxException {
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/"), (String)"ssh://somehost"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost"), (String)"http://somehost/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost:80/"), (String)"http://somehost/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost"), (String)"http://somehost:80/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost:443"), (String)"https://somehost/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/"), (String)"https://somehost:443/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost:443/"), (String)"https://somehost:443/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/jenkins"), (String)"http://somehost/jenkins"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost:80/jenkins"), (String)"http://somehost:80/jenkins"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins"), (String)"https://somehost/jenkins"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins?query=true"), (String)"https://somehost/jenkins?query=true"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins/?query=some%20path"), (String)"https://somehost/jenkins?query=some%20path"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins"), (String)"https://user@somehost/jenkins"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins"), (String)"https://user:password@somehost/jenkins"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"ssh://user:password@somehost:22/path"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"invalid/url"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"ssh://somehost/other/path"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"ssh://somehost/other/path"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/path"), (String)"http://somehost/"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/path"), (String)"http://somehost/path?query=test"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("/var/hg/stuff"), (String)"/var/hg/stuff"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("file:///var/hg/stuff"), (String)"/var/hg/stuff"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("file:/var/hg/stuff"), (String)"/var/hg/stuff"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("/var/hg/stuff"), (String)"file:/var/hg/stuff"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("/var/hg/stuff"), (String)"file:///var/hg/stuff"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("file:///var/hg/stuff"), (String)"file:///var/hg/stuff"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/"), (String)"ssh://somehost/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/"), (String)"http://somehost/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/"), (String)"https://somehost/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost:80/"), (String)"ssh://somehost:22/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost:443/"), (String)"http://somehost:80/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost:22/"), (String)"https://somehost:443/"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/path"), (String)"ssh://somehost/path"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/path"), (String)"http://somehost/path"));
        Assertions.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"https://somehost/path"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://scm.foocompany.com/hg/foocomponent/"), (String)"${REPO_URL}"));
        Assertions.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://scm.foocompany.com/hg/foocomponent/"), (String)"$REPO_URL"));
    }
}

