/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.Launcher;
import hudson.Proc;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.LabelAxis;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PretendSlave;
import org.jvnet.hudson.test.TestBuilder;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class MatrixProjectTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;
    @TempDir
    private File tmp2;
    private File repo;
    private MatrixProject matrixProject;

    MatrixProjectTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) throws Exception {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.repo = this.tmp;
        this.createPretendAgent("agent_one");
        this.createPretendAgent("agent_two");
        this.matrixProject = (MatrixProject)this.j.createProject(MatrixProject.class, "matrix_test");
        this.matrixProject.setScm((SCM)new MercurialSCM(null, this.repo.getPath(), null, null, null, null, false));
        this.matrixProject.setAxes(new AxisList(new Axis[]{new LabelAxis("label", Arrays.asList("agent_one", "agent_two"))}));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
    }

    @Test
    void allRunsBuildSameRevisionOnClone() throws Exception {
        this.assertAllMatrixRunsBuildSameMercurialRevision();
    }

    @Test
    void allRunsBuildSameRevisionOnUpdate() throws Exception {
        this.j.assertBuildStatusSuccess((Future)this.matrixProject.scheduleBuild2(0));
        this.m.touchAndCommit(this.repo, "ab");
        this.assertAllMatrixRunsBuildSameMercurialRevision();
    }

    private void assertAllMatrixRunsBuildSameMercurialRevision() throws Exception {
        Node agentTwo = this.j.jenkins.getNode("agent_two");
        agentTwo.toComputer().setTemporarilyOffline(true, null);
        final CountDownLatch firstBuild = new CountDownLatch(1);
        this.matrixProject.getBuildersList().add((Object)new TestBuilder(this){
            final /* synthetic */ MatrixProjectTest this$0;
            {
                this.this$0 = this$0;
            }

            public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
                firstBuild.countDown();
                return true;
            }
        });
        QueueTaskFuture matrixBuildFuture = this.matrixProject.scheduleBuild2(0);
        firstBuild.await(5L, TimeUnit.SECONDS);
        this.m.touchAndCommit(this.repo, "b");
        agentTwo.toComputer().setTemporarilyOffline(false, null);
        MatrixBuild r = (MatrixBuild)matrixBuildFuture.get();
        this.j.assertBuildStatus(Result.SUCCESS, (Run)r);
        List runs = r.getRuns();
        HashSet<String> builtIds = new HashSet<String>();
        for (MatrixRun run : runs) {
            MercurialTagAction builtRevision = (MercurialTagAction)run.getAction(MercurialTagAction.class);
            String buildId = builtRevision.getId();
            builtIds.add(buildId);
        }
        Assertions.assertEquals((int)1, (int)builtIds.size(), (String)("All runs should build the same Mercurial revision, but they built " + String.valueOf(builtIds)));
    }

    private PretendSlave createPretendAgent(String agentName) throws Exception {
        PretendSlave agent = new PretendSlave(agentName, this.tmp2.getAbsolutePath(), "", this.j.createComputerLauncher(null), (FakeLauncher)new NoopFakeLauncher());
        this.j.jenkins.addNode((Node)agent);
        return agent;
    }

    private static class NoopFakeLauncher
    implements FakeLauncher {
        private NoopFakeLauncher() {
        }

        public Proc onLaunch(Launcher.ProcStarter p) {
            return null;
        }
    }
}

