/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.Parameter;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
@WithJenkins
@ParameterizedClass(name="{index}: agent={0} {1} {2}")
@MethodSource(value={"data"})
class FunctionalTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;
    private MercurialContainer container;
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    @Parameter(value=0)
    private boolean useAgent;
    @Parameter(value=1)
    private MercurialInstallationFactory mercurialInstallationFactory;
    @Parameter(value=2)
    private MercurialContainer.Version mercurialVersion;
    private FilePath repo;
    private Slave agent;
    private MercurialInstallation inst;

    FunctionalTest() {
    }

    static Object[][] data() {
        MercurialInstallationFactory defaultFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "default";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave agent, MercurialContainer.Version version) throws Exception {
                if (agent != null) {
                    return container.createInstallation(j, version, false, false, false, "", agent);
                }
                assert (version == null);
                return null;
            }
        };
        MercurialInstallationFactory cachingFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "caching";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave agent, MercurialContainer.Version version) throws Exception {
                if (agent != null) {
                    return container.createInstallation(j, version, false, true, false, "", agent);
                }
                assert (version == null);
                MercurialInstallation inst = new MercurialInstallation("whatever", "", "hg", false, true, false, null);
                ((MercurialInstallation.DescriptorImpl)j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{inst});
                return inst;
            }
        };
        MercurialInstallationFactory sharingFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "sharing";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave agent, MercurialContainer.Version version) throws Exception {
                if (agent != null) {
                    return container.createInstallation(j, version, false, true, true, "", agent);
                }
                assert (version == null);
                MercurialInstallation inst = new MercurialInstallation("whatever", "", "hg", false, true, true, null);
                ((MercurialInstallation.DescriptorImpl)j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{inst});
                return inst;
            }
        };
        MercurialInstallationFactory debugFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "debug";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave agent, MercurialContainer.Version version) throws Exception {
                if (agent != null) {
                    return container.createInstallation(j, version, true, false, false, "", agent);
                }
                assert (version == null);
                MercurialInstallation inst = new MercurialInstallation("whatever", "", "hg", true, false, false, null);
                ((MercurialInstallation.DescriptorImpl)j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{inst});
                return inst;
            }
        };
        return new Object[][]{{false, defaultFactory, null}, {true, defaultFactory, MercurialContainer.Version.HG6}, {false, cachingFactory, null}, {true, cachingFactory, MercurialContainer.Version.HG6}, {false, sharingFactory, null}, {true, sharingFactory, MercurialContainer.Version.HG6}, {false, debugFactory, null}, {true, debugFactory, MercurialContainer.Version.HG6}};
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) throws Exception {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        if (this.useAgent) {
            this.container = new MercurialContainer();
            this.container.start();
            this.agent = this.container.createAgent(this.j);
        }
        this.inst = this.mercurialInstallationFactory.create(this.j, this.container, this.agent, this.mercurialVersion);
        if (this.inst != null && this.inst.isUseCaches() || this.agent == null) {
            this.repo = new FilePath(this.tmp);
        } else {
            this.repo = this.agent.getRootPath().child("repo");
            this.repo.mkdirs();
            this.m.withNode((Node)this.agent);
            this.m.withInstallation(this.inst);
        }
    }

    @AfterEach
    void afterEach() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    @Test
    void basics() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.inst != null ? this.inst.getName() : null, this.repo.getRemote(), null, null, null, null, false));
        if (this.agent != null) {
            p.setAssignedNode((Node)this.agent);
        }
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        String log = this.m.buildAndCheck(p, "a", new Action[0]);
        FunctionalTest.assertClone(log, true);
        this.m.touchAndCommit(this.repo, "b");
        log = this.m.buildAndCheck(p, "b", new Action[0]);
        FunctionalTest.assertClone(log, false);
    }

    private static void assertClone(String log, boolean cloneExpected) {
        if (cloneExpected) {
            Assertions.assertTrue((boolean)log.contains(" clone --"), (String)log);
        } else {
            Assertions.assertTrue((boolean)log.contains(" update --"), (String)log);
            Assertions.assertFalse((boolean)log.contains(" clone --"), (String)log);
        }
    }

    @Test
    void branches() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "init");
        this.m.hg(this.repo, "tag", "init");
        this.m.touchAndCommit(this.repo, "default-1");
        this.m.hg(this.repo, "update", "--clean", "init");
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "b-1");
        FreeStyleProject p = this.j.createFreeStyleProject();
        if (this.agent != null) {
            p.setAssignedNode((Node)this.agent);
        }
        p.setScm((SCM)new MercurialSCM(this.inst != null ? this.inst.getName() : null, this.repo.getRemote(), "b", null, null, null, false));
        this.m.buildAndCheck(p, "b-1", new Action[0]);
        this.m.hg(this.repo, "update", "--clean", "default");
        this.m.touchAndCommit(this.repo, "default-2");
        Assertions.assertFalse((boolean)this.m.pollSCMChanges(p).hasChanges());
        this.m.hg(this.repo, "update", "--clean", "b");
        this.m.touchAndCommit(this.repo, "b-2");
        Assertions.assertTrue((boolean)this.m.pollSCMChanges(p).hasChanges());
        this.m.buildAndCheck(p, "b-2", new Action[0]);
        p.setScm((SCM)new MercurialSCM(this.inst != null ? this.inst.getName() : null, this.repo.getRemote(), null, null, null, null, false));
        Assertions.assertTrue((boolean)this.m.pollSCMChanges(p).hasChanges());
        this.m.buildAndCheck(p, "default-2", new Action[0]);
        this.m.touchAndCommit(this.repo, "b-3");
        Assertions.assertFalse((boolean)this.m.pollSCMChanges(p).hasChanges());
    }

    public static interface MercurialInstallationFactory {
        @CheckForNull
        public MercurialInstallation create(@NonNull JenkinsRule var1, @CheckForNull MercurialContainer var2, @CheckForNull Slave var3, @Nullable MercurialContainer.Version var4) throws Exception;

        public String toString();
    }
}

