/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.EnvVars;
import hudson.XmlFile;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class ConfigurationTest {
    private JenkinsRule r;

    ConfigurationTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void configRoundTrip() throws Exception {
        FreeStyleProject p = this.r.createFreeStyleProject();
        MercurialSCM scm = new MercurialSCM("http://repo/");
        Assertions.assertEquals((Object)"default", (Object)scm.getRevision());
        Assertions.assertEquals((Object)MercurialSCM.RevisionType.BRANCH, (Object)scm.getRevisionType());
        Assertions.assertFalse((boolean)scm.isClean());
        Assertions.assertNull((Object)scm.getCredentialsId());
        scm.setClean(true);
        scm.setRevisionType(MercurialSCM.RevisionType.TAG);
        scm.setRevision("LATEST");
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, "test", "bob", "s3cr3t");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        scm.setCredentialsId(c.getId());
        scm.setModules("src");
        scm.setSubdir("checkout");
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("caching", null, "hg", false, true, false, null, null)});
        scm.setInstallation("caching");
        p.setScm((SCM)scm);
        XmlFile xml = p.getConfigFile();
        System.out.println(xml.asString());
        this.r.configRoundtrip((Item)p);
        System.out.println(xml.asString());
        scm = (MercurialSCM)p.getScm();
        Assertions.assertEquals((Object)"http://repo/", (Object)scm.getSource());
        Assertions.assertTrue((boolean)scm.isClean());
        Assertions.assertEquals((Object)MercurialSCM.RevisionType.TAG, (Object)scm.getRevisionType());
        Assertions.assertEquals((Object)"LATEST", (Object)scm.getRevision());
        Assertions.assertEquals((Object)c.getId(), (Object)scm.getCredentialsId());
        Assertions.assertEquals((Object)"s3cr3t", (Object)((UsernamePasswordCredentialsImpl)scm.getCredentials((Job)p, new EnvVars())).getPassword().getPlainText());
        Assertions.assertEquals((Object)"src", (Object)scm.getModules());
        Assertions.assertEquals((Object)"checkout", (Object)scm.getSubdir());
        Assertions.assertEquals((Object)"caching", (Object)scm.getInstallation());
        Assertions.assertFalse((boolean)scm.isDisableChangeLog());
    }

    @Test
    void doFillCredentialsIdItemsWithoutJobWhenAdmin() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"alice"}));
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, "test", "bob", "s3cr3t");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        try (ACLContext context = ACL.as((User)User.get((String)"alice"));){
            ListBoxModel options = ((MercurialSCM.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialSCM.DescriptorImpl.class)).doFillCredentialsIdItems(null, "http://nowhere.net/");
            Assertions.assertEquals((Object)CredentialsNameProvider.name((Credentials)c), (Object)((ListBoxModel.Option)options.get((int)1)).name);
        }
    }

    @Test
    void doFillCredentialsIdItems() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        FreeStyleProject p1 = this.r.createFreeStyleProject("p1");
        FreeStyleProject p2 = this.r.createFreeStyleProject("p2");
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"alice", "bob"}).grant(new Permission[]{Item.CONFIGURE}).onItems(new Item[]{p2}).to(new String[]{"bob"}));
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, "test", "bob", "s3cr3t");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        this.assertCredentials("alice", null, new Credentials[0]);
        this.assertCredentials("alice", (Job<?, ?>)p1, new Credentials[0]);
        this.assertCredentials("alice", (Job<?, ?>)p2, new Credentials[0]);
        this.assertCredentials("bob", null, new Credentials[0]);
        this.assertCredentials("bob", (Job<?, ?>)p1, new Credentials[0]);
        this.assertCredentials("bob", (Job<?, ?>)p2, new Credentials[]{c});
    }

    private void assertCredentials(String user, Job<?, ?> owner, Credentials ... expected) {
        ArrayList<String> expectedNames = new ArrayList<String>();
        for (Credentials c : expected) {
            expectedNames.add(CredentialsNameProvider.name((Credentials)c));
        }
        try (ACLContext context = ACL.as((User)User.get((String)user));){
            ArrayList<String> actualNames = new ArrayList<String>();
            for (ListBoxModel.Option o : ((MercurialSCM.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialSCM.DescriptorImpl.class)).doFillCredentialsIdItems(owner, "http://nowhere.net/")) {
                if (o.value.isEmpty()) continue;
                actualNames.add(o.name);
            }
            Assertions.assertEquals(expectedNames, actualNames);
        }
    }
}

