/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class CachingCustomDirSCMTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;
    private File repo;
    private static final String CACHING_INSTALLATION = "caching-custom-dir";

    CachingCustomDirSCMTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) throws Exception {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.repo = this.tmp;
        ((MercurialInstallation.DescriptorImpl)this.j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(CACHING_INSTALLATION, "", "hg", false, true, new File(CachingCustomDirSCMTest.newFolder(this.tmp, "junit"), "custom-cache-dir").getAbsolutePath(), false, "", Collections.emptyList())});
    }

    @Test
    void customCacheLocationFromSlave() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(CACHING_INSTALLATION, this.repo.getPath(), null, null, null, null, false));
        p.setAssignedNode((Node)this.j.createOnlineSlave());
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        String log = this.m.buildAndCheck(p, "a", new Action[0]);
        Pattern pattern = Pattern.compile("hg clone .*custom-cache-dir");
        Assertions.assertTrue((boolean)pattern.matcher(log).find());
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + String.valueOf(root));
        }
        return result;
    }
}

