package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.util.Secret;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.jvnet.hudson.test.Issue;

class CacheTest {

    @Test
    void hashSource() {
        assertEquals("5439A9B4063BB8F4885037E71B5079E1913DB6CA-core-main", Cache.hashSource("http://hg.netbeans.org/core-main/", null, null));
        assertEquals("5439A9B4063BB8F4885037E71B5079E1913DB6CA-core-main", Cache.hashSource("http://hg.netbeans.org/core-main", null, null));
        assertEquals("5731708C5EEAF9F1320B57D5F6A21E85EA5ADF2D-project", Cache.hashSource("ssh://dude@math.utexas.edu/some/project/", null, null));
        assertEquals("210ED9E2610F74A473985D8D9EF4483D5D30265E-project", Cache.hashSource("ssh://dudette@math.utexas.edu/some/project/", null, null));
        assertEquals("D3D58986EB0F726F38EE6393B1DB943C0BAD0B4D-project", Cache.hashSource("ssh://dudette@math.utexas.edu/some/project/", null, "/var/tmp/hgcache"));
        // Cannot use UsernamePasswordCredentialsImpl from a unit test, since it tries to actually decrypt the password, which requires Jenkins.instance.
        assertEquals("0D1FD823FDA2F7144C463007FEAF9F824333B3D2-core-main-bob-at-nowhere.net",
				Cache.hashSource("http://hg.netbeans.org/core-main/", new MockUsernamePasswordCredentials(CredentialsScope.GLOBAL, "what-ever", "bob@nowhere.net"),null));
    }

    @Issue("JENKINS-12544")
    @Test
    void hashSource2() {
        assertEquals("DA7E6A4632009859A61A551999EE2109EBB69267-ronaldradial", Cache.hashSource("http://ronaldradial:8000/", null,null));
    }

    private static class MockUsernamePasswordCredentials extends BaseStandardCredentials implements StandardUsernamePasswordCredentials {
        private final String username;
        MockUsernamePasswordCredentials(CredentialsScope scope, String id, String username) {
            super(scope, id, "");
            this.username = username;
        }
        @Override public String getUsername() {
            return username;
        }
        @Override public Secret getPassword() {
            return null;
        }
    }

}
