/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.Extension;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ScmManager
extends HgBrowser {
    @DataBoundConstructor
    public ScmManager(String url) throws MalformedURLException {
        super(url);
    }

    @Override
    public URL getChangeSetLink(MercurialChangeSet changeSet) throws IOException {
        this.current = changeSet;
        return new URL(this.getUrl(), "code/changeset/" + changeSet.getNode());
    }

    @Override
    public URL getFileLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "code/sources/" + this.current.getNode() + "/" + path);
    }

    @Override
    public URL getDiffLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "code/changeset/" + this.current.getNode() + "/#diff-" + path);
    }

    @Extension
    public static class DescriptorImpl
    extends HgBrowser.HgBrowserDescriptor {
        public String getDisplayName() {
            return "SCM-Manager";
        }

        @Override
        public FormValidation doCheckUrl(@QueryParameter String url) {
            return this._doCheckUrl(url);
        }

        @Override
        protected FormValidation check(URL url) {
            if (url.toString().matches("https?://.*/repo/[^/]+/[^/]+/?")) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Possibly incorrect root URL; expected URL which starts with http or https and ends with /repo/namespace/name");
        }
    }
}

