/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.Messages;
import hudson.scm.SCM;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.triggers.SCMTriggerItem;
import org.kohsuke.stapler.DataBoundConstructor;

public class MercurialRevisionColumn
extends ListViewColumn {
    @DataBoundConstructor
    public MercurialRevisionColumn() {
    }

    public String getMercurialRevision(Item item) {
        SCMTriggerItem s = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item);
        if (s == null) {
            return "";
        }
        String revision = null;
        for (SCM scm : s.getSCMs()) {
            if (!(scm instanceof MercurialSCM)) {
                return "";
            }
            String _revision = ((MercurialSCM)scm).getRevision();
            if (revision != null && !revision.equals(_revision)) {
                return "";
            }
            revision = _revision;
        }
        return revision != null ? revision : "";
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.MercurialRevisionColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

