/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.Util;
import hudson.model.Run;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialChangeSetList;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import jenkins.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MercurialChangeLogParser
extends ChangeLogParser {
    private final Set<String> modules;

    public MercurialChangeLogParser(Set<String> modules) {
        this.modules = modules;
    }

    public MercurialChangeSetList parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
        Element changesetsE;
        ArrayList<MercurialChangeSet> r = new ArrayList<MercurialChangeSet>();
        try {
            changesetsE = XMLUtils.parse((File)changelogFile, (String)"UTF-8").getDocumentElement();
        }
        catch (IOException e) {
            throw new IOException("Failed to parse " + String.valueOf(changelogFile), e);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse " + String.valueOf(changelogFile) + ": '" + Util.loadFile((File)changelogFile) + "'", e);
        }
        NodeList changesetsNL = changesetsE.getChildNodes();
        for (int i = 0; i < changesetsNL.getLength(); ++i) {
            if (changesetsNL.item(i).getNodeType() != 1) continue;
            Element changesetE = (Element)changesetsNL.item(i);
            MercurialChangeSet cs = new MercurialChangeSet();
            cs.setNode(changesetE.getAttribute("node"));
            if (changesetE.hasAttribute("user")) {
                cs.setAuthor(changesetE.getAttribute("user"));
            } else {
                cs.setAuthor(changesetE.getAttribute("author"));
            }
            if (changesetE.hasAttribute("rev")) {
                cs.setRev(Long.parseLong(changesetE.getAttribute("rev")));
            }
            cs.setDate(changesetE.getAttribute("date"));
            NodeList changesetNL = changesetE.getChildNodes();
            block24: for (int j = 0; j < changesetNL.getLength(); ++j) {
                if (changesetNL.item(j).getNodeType() != 1) continue;
                Element otherE = (Element)changesetNL.item(j);
                String text = otherE.getTextContent();
                switch (otherE.getTagName()) {
                    case "msg": {
                        cs.setMsg(text);
                        continue block24;
                    }
                    case "added": {
                        cs.setAdded(text);
                        continue block24;
                    }
                    case "deleted": {
                        cs.setDeleted(text);
                        continue block24;
                    }
                    case "files": {
                        cs.setFiles(text);
                        continue block24;
                    }
                    case "file": {
                        cs.addFile(text);
                        continue block24;
                    }
                    case "addedFile": {
                        cs.addAddedFile(text);
                        continue block24;
                    }
                    case "deletedFile": {
                        cs.addDeletedFile(text);
                        continue block24;
                    }
                    case "parents": {
                        cs.setParents(text);
                        continue block24;
                    }
                    default: {
                        throw new IOException(otherE.getTagName());
                    }
                }
            }
            r.add(cs);
        }
        if (this.modules != null) {
            Iterator it = r.iterator();
            while (it.hasNext()) {
                boolean include = false;
                block26: for (String path : ((MercurialChangeSet)((Object)it.next())).getAffectedPaths()) {
                    for (String module : this.modules) {
                        if (!path.startsWith(module)) continue;
                        include = true;
                        break block26;
                    }
                }
                if (include) continue;
                it.remove();
            }
        }
        r.sort(Comparator.comparingLong(MercurialChangeSet::getRev));
        return new MercurialChangeSetList(build, browser, r);
    }
}

