/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamTaskListener;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
@WithJenkins
class MercurialContainerTest {
    private JenkinsRule r;
    @Container
    private static final MercurialContainer container = new MercurialContainer();

    MercurialContainerTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void smokes() throws Exception {
        Slave slave = container.createAgent(this.r);
        StreamTaskListener listener = StreamTaskListener.fromStdout();
        for (MercurialContainer.Version v : MercurialContainer.Version.values()) {
            HgExe hgExe = new HgExe(container.createInstallation(this.r, v, false, false, false, "", slave), null, slave.createLauncher((TaskListener)listener), (Node)slave, (TaskListener)listener, new EnvVars());
            MatcherAssert.assertThat((Object)hgExe.popen(slave.getRootPath(), (TaskListener)listener, true, new ArgumentListBuilder(new String[]{"version"})), (Matcher)Matchers.containsString((String)("Mercurial Distributed SCM (version " + v.exactVersion + ")")));
        }
    }
}

