/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class EnvVarTest {
    private JenkinsRule r;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;

    EnvVarTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
        this.m = new MercurialTestUtil(this.r);
    }

    @Test
    void customConfiguration() throws Exception {
        String key = "ENVVARTESTVAR";
        String val = "EnvVarTestDir";
        EnvVars env = new EnvVars(new String[]{"ENVVARTESTVAR", "EnvVarTestDir"});
        File repo = new File(String.valueOf(this.tmp) + "/$ENVVARTESTVAR");
        File repoExpanded = new File(String.valueOf(this.tmp) + "/EnvVarTestDir");
        repoExpanded.mkdir();
        this.m.hg(repo, env, "init");
        Assertions.assertTrue((boolean)new File(String.valueOf(repoExpanded) + "/.hg").isDirectory(), (String)(new File(String.valueOf(repoExpanded) + "/.hg").getPath() + " does not exist"));
        this.m.touchAndCommit(repoExpanded, "f");
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("test", "", "hg", false, false, false, "[format]\nusestore = false", null)});
        FreeStyleProject project = this.r.createFreeStyleProject();
        ParametersDefinitionProperty pdb = new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("ENVVARTESTVAR", "EnvVarTestDir", "")});
        project.addProperty((JobProperty)pdb);
        project.setScm((SCM)new MercurialSCM("test", repo.getPath(), MercurialSCM.RevisionType.BRANCH, null, null, null, null, false, null, false));
        FreeStyleBuild b = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)project.scheduleBuild2(0));
        b = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)project.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assertions.assertNotNull((Object)ws);
        String requires = ws.child(".hg/requires").readToString();
        Assertions.assertFalse((boolean)requires.contains("store"), (String)requires);
    }
}

