/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class CustomConfigTest {
    private JenkinsRule r;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;

    CustomConfigTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
        this.m = new MercurialTestUtil(this.r);
    }

    @Test
    void customConfiguration() throws Exception {
        File repo = this.tmp;
        this.m.hg(repo, "init");
        this.m.touchAndCommit(repo, "f");
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("test", "", "hg", false, false, false, "[format]\nusestore = false", null)});
        FreeStyleProject p = this.r.createFreeStyleProject();
        MercurialSCM scm = new MercurialSCM(repo.getPath());
        scm.setInstallation("test");
        scm.setRevisionType(MercurialSCM.RevisionType.BRANCH);
        scm.setDisableChangeLog(false);
        p.setScm((SCM)scm);
        FreeStyleBuild b = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assertions.assertNotNull((Object)ws);
        String requires = ws.child(".hg/requires").readToString();
        Assertions.assertFalse((boolean)requires.contains("store"), (String)requires);
    }
}

