/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialChangeLogParserTest;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialChangeSetList;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.Parameter;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.EnumSource;
import org.jvnet.hudson.test.For;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
@ParameterizedClass
@EnumSource(value=MercurialContainer.Version.class)
@WithJenkins
@For(value={MercurialChangeSet.class, MercurialChangeLogParser.class})
class ChangelogTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @Container
    private static final MercurialContainer container = new MercurialContainer();
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    @Parameter(value=0)
    private MercurialContainer.Version mercurialVersion;
    private FilePath repo;
    private Slave agent;
    private MercurialInstallation inst;

    ChangelogTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) throws Exception {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.agent = container.createAgent(this.j);
        this.inst = container.createInstallation(this.j, this.mercurialVersion, false, false, false, "", this.agent);
        this.repo = this.agent.getRootPath().child("repo");
        this.repo.mkdirs();
        this.m.withNode((Node)this.agent);
        this.m.withInstallation(this.inst);
    }

    @Test
    void spacesInPaths() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        MercurialSCM scm = new MercurialSCM(this.repo.getRemote());
        scm.setInstallation(this.inst.getName());
        p.setScm((SCM)scm);
        p.setAssignedNode((Node)this.agent);
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "one", "two");
        ChangelogTest.assertChangelog("", p);
        this.m.touchAndCommit(this.repo, "two", "three");
        ChangelogTest.assertChangelog("added=[three] deleted=[] modified=[two] ", p);
        this.m.hg(this.repo, "rm", "one", "three");
        this.m.hg(this.repo, "commit", "--message", "removed");
        ChangelogTest.assertChangelog("added=[] deleted=[one, three] modified=[] ", p);
        this.m.touchAndCommit(this.repo, "some -> thing");
        ChangelogTest.assertChangelog("added=[some -> thing] deleted=[] modified=[] ", p);
        this.m.touchAndCommit(this.repo, "some -> thing", "two");
        ChangelogTest.assertChangelog("added=[] deleted=[] modified=[some -> thing, two] ", p);
        this.m.hg(this.repo, "rm", "some -> thing");
        this.m.hg(this.repo, "commit", "--message", "removed");
        ChangelogTest.assertChangelog("added=[] deleted=[some -> thing] modified=[] ", p);
    }

    private static void assertChangelog(String summary, FreeStyleProject p) throws Exception {
        Assertions.assertEquals((Object)summary, (Object)MercurialChangeLogParserTest.summary((MercurialChangeSetList)((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet()));
    }
}

