/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.User;
import hudson.plugins.mercurial.MercurialAffectedFile;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;

public class MercurialChangeSet
extends ChangeLogSet.Entry {
    private String node;
    private String author;
    private long rev;
    private String date;
    private String msg;
    private boolean merge;
    private List<String> added = new ArrayList<String>();
    private List<String> deleted = new ArrayList<String>();
    private List<String> modified = new ArrayList<String>();
    private volatile List<String> affectedPaths;
    static final String CHANGELOG_TEMPLATE = "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg>{file_adds % '<addedFile>{file|xmlescape}</addedFile>'}{file_dels % '<deletedFile>{file|xmlescape}</deletedFile>'}{files % '<file>{file|xmlescape}</file>'}<parents>{parents}</parents></changeset>\\n";

    @Exported
    public String getMsg() {
        return this.msg;
    }

    @Exported
    public User getAuthor() {
        return User.get((String)this.author);
    }

    @Exported
    public String getNode() {
        return this.node;
    }

    public String getShortNode() {
        return this.node.substring(0, 12);
    }

    @Exported
    public long getRev() {
        return this.rev;
    }

    @Deprecated
    public String getRevision() {
        return this.node;
    }

    public String getCommitId() {
        return this.node;
    }

    public long getTimestamp() {
        return Long.parseLong(this.date.split("\\.")[0]) * 1000L;
    }

    @Exported
    public String getDate() {
        return this.date;
    }

    public Collection<String> getAffectedPaths() {
        if (this.affectedPaths == null) {
            ArrayList<String> r = new ArrayList<String>(this.added.size() + this.modified.size() + this.deleted.size());
            r.addAll(this.added);
            r.addAll(this.modified);
            r.addAll(this.deleted);
            this.affectedPaths = r;
        }
        return this.affectedPaths;
    }

    public Collection<? extends ChangeLogSet.AffectedFile> getAffectedFiles() {
        ArrayList<MercurialAffectedFile> affected = new ArrayList<MercurialAffectedFile>(this.added.size() + this.modified.size() + this.deleted.size());
        for (EditType editType : EditType.ALL) {
            for (String path : this.getPaths(editType)) {
                affected.add(new MercurialAffectedFile(editType, path));
            }
        }
        return affected;
    }

    @Exported
    public List<String> getAddedPaths() {
        return this.added;
    }

    @Exported
    public List<String> getDeletedPaths() {
        return this.deleted;
    }

    @Exported
    public List<String> getModifiedPaths() {
        return this.modified;
    }

    @Exported
    public boolean isMerge() {
        return this.merge;
    }

    public List<String> getPaths(EditType kind) {
        if (kind == EditType.ADD) {
            return this.getAddedPaths();
        }
        if (kind == EditType.EDIT) {
            return this.getModifiedPaths();
        }
        if (kind == EditType.DELETE) {
            return this.getDeletedPaths();
        }
        return null;
    }

    public List<EditType> getEditTypes() {
        return Arrays.asList(EditType.ADD, EditType.EDIT, EditType.DELETE);
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
        if (this.merge) {
            this.added = Collections.emptyList();
            this.deleted = Collections.emptyList();
            this.modified = Collections.emptyList();
        } else {
            this.modified = new ArrayList<String>(this.modified);
            this.modified.removeAll(this.added);
            this.modified.removeAll(this.deleted);
        }
    }

    void setMsg(String msg) {
        this.msg = msg;
    }

    @Restricted(value={NoExternalUse.class})
    public void setNode(String node) {
        this.node = node;
    }

    void setAuthor(String author) {
        this.author = author;
    }

    void setRev(long rev) {
        this.rev = rev;
    }

    void setDate(String date) {
        this.date = date;
    }

    void addAddedFile(String file) {
        this.added.add(file);
    }

    void addDeletedFile(String file) {
        this.deleted.add(file);
    }

    void addFile(String file) {
        this.modified.add(file);
    }

    void setAdded(String list) {
        if (this.merge) {
            return;
        }
        this.added = this.toList(list);
    }

    void setDeleted(String list) {
        if (this.merge) {
            return;
        }
        this.deleted = this.toList(list);
    }

    void setFiles(String list) {
        if (this.merge) {
            return;
        }
        this.modified = this.toList(list);
    }

    void setParents(String parents) {
        this.merge = parents.indexOf(58) != parents.lastIndexOf(58) && !parents.contains("-1");
    }

    private List<String> toList(String list) {
        if ((list = list.trim()).length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(list.split(" "));
    }
}

