/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.browser.GoogleCode;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.LocalData;

public class HgBrowserSelectionTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();

    @LocalData
    @Test
    public void repositoryBrowserCompatibility() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.j.jenkins.getItem("foo");
        MercurialSCM ms = (MercurialSCM)p.getScm();
        RepositoryBrowser browser = ms.getEffectiveBrowser();
        Assert.assertTrue((String)String.valueOf(browser), (boolean)(browser instanceof HgWeb));
        this.j.assertEqualBeans((Object)new HgWeb("http://www.yahoo.com/"), (Object)browser, "url");
    }

    @LocalData
    @Test
    public void pickingUpAlternativeBrowser() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.j.jenkins.getItem("foo");
        MercurialSCM ms = (MercurialSCM)p.getScm();
        HgBrowser browser = ms.getBrowser();
        Assert.assertEquals((String)"wrong url", (Object)"http://code.google.com/p/xxx/source/", (Object)browser.getUrl().toString());
        Assert.assertTrue((String)("class:" + String.valueOf(browser.getClass())), (boolean)(browser instanceof GoogleCode));
        this.j.assertEqualBeans((Object)new GoogleCode("http://code.google.com/p/xxx/source/"), (Object)browser, "url");
    }

    @LocalData
    @Test
    public void browsersAvailableInDropDown() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.j.jenkins.getItem("foo");
        MercurialSCM ms = (MercurialSCM)p.getScm();
        HgBrowser browser = ms.getBrowser();
        Assert.assertEquals((String)"wrong url", (Object)"http://code.google.com/p/xxx/source/", (Object)browser.getUrl().toString());
        Assert.assertTrue((String)("class:" + String.valueOf(browser.getClass())), (boolean)(browser instanceof GoogleCode));
        this.j.assertEqualBeans((Object)new GoogleCode("http://code.google.com/p/xxx/source/"), (Object)browser, "url");
        List browserDescriptors = ms.getDescriptor().getBrowserDescriptors();
        Assert.assertTrue((String)("Could not find GoogleCode in " + String.valueOf(browserDescriptors)), (boolean)browserDescriptors.contains(browser.getDescriptor()));
    }

    @Test
    public void configureBrowser() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(null, "https://host/repo", null, null, null, (HgBrowser)new HgWeb("https://host/repo"), false, null));
        this.j.configRoundtrip((Item)p);
        Assert.assertEquals((Object)"https://host/repo/", (Object)((MercurialSCM)p.getScm()).getBrowser().getUrl().toString());
    }
}

