/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import java.io.File;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class SwitchingSCMTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private File repo;
    protected String cachingInstallation = "caching";
    protected String sharingInstallation = "sharing";

    @Before
    public void setUp() throws Exception {
        this.repo = this.tmp.getRoot();
        ((MercurialInstallation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(this.cachingInstallation, "", "hg", false, true, false, Collections.emptyList())});
        ((MercurialInstallation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(this.sharingInstallation, "", "hg", false, true, true, Collections.emptyList())});
    }

    @Test
    public void switchingFromCachedToShared() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.cachingInstallation, this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        this.m.buildAndCheck(p, "a", new Action[0]);
        Assert.assertFalse((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
        p.setScm((SCM)new MercurialSCM(this.sharingInstallation, this.repo.getPath(), null, null, null, null, false));
        this.m.touchAndCommit(this.repo, "b");
        this.m.buildAndCheck(p, "b", new Action[0]);
        Assert.assertTrue((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
    }

    public void testSwitchingFromSharedToCached() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.sharingInstallation, this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        this.m.buildAndCheck(p, "a", new Action[0]);
        Assert.assertTrue((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
        p.setScm((SCM)new MercurialSCM(this.cachingInstallation, this.repo.getPath(), null, null, null, null, false));
        this.m.touchAndCommit(this.repo, "b");
        this.m.buildAndCheck(p, "b", new Action[0]);
        Assert.assertFalse((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
    }
}

