/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.slaves.DumbSlave;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.jvnet.hudson.test.FlagRule;
import org.jvnet.hudson.test.JenkinsRule;

public class Security2478Test {
    private static final String INSTALLATION = "mercurial";
    @Rule
    public JenkinsRule rule = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.rule);
    @Rule
    public TestRule notAllowNonRemoteCheckout = new FlagRule(() -> MercurialSCM.ALLOW_LOCAL_CHECKOUT, x -> {
        MercurialSCM.ALLOW_LOCAL_CHECKOUT = x;
    }, (Object)false);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private File repo;

    @Before
    public void setUp() throws Exception {
        this.repo = this.tmp.getRoot();
        ((MercurialInstallation.DescriptorImpl)this.rule.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(INSTALLATION, "", "hg", false, true, new File(this.tmp.newFolder(), "custom-dir").getAbsolutePath(), false, "", Collections.emptyList())});
    }

    @Test
    public void checkoutShouldAbortWhenSourceIsNonRemoteAndBuildOnController() throws Exception {
        Assert.assertFalse((String)"Non Remote checkout should be disallowed", (boolean)MercurialSCM.ALLOW_LOCAL_CHECKOUT);
        WorkflowJob p = (WorkflowJob)this.rule.jenkins.createProject(WorkflowJob.class, "pipeline");
        FilePath sourcePath = this.rule.jenkins.getRootPath().createTempDir("t", "");
        String script = "node {\ncheckout([$class: 'MercurialSCM', credentialsId: '', installation: 'mercurial', source: '" + String.valueOf(sourcePath) + "'])\n}";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        WorkflowRun run = (WorkflowRun)this.rule.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        this.rule.assertLogContains("Checkout of Mercurial source '" + String.valueOf(sourcePath) + "' aborted because it references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property '" + MercurialSCM.ALLOW_LOCAL_CHECKOUT_PROPERTY + "' to true.", (Run)run);
    }

    @Test
    public void checkoutOnAgentShouldNotAbortWhenSourceIsNonRemoteAndBuildOnAgent() throws Exception {
        Assert.assertFalse((String)"Non Remote checkout should be disallowed", (boolean)MercurialSCM.ALLOW_LOCAL_CHECKOUT);
        DumbSlave agent = this.rule.createOnlineSlave();
        FilePath workspace = agent.getRootPath().child("testws");
        workspace.mkdirs();
        this.m.hg(workspace, "init");
        this.m.touchAndCommit(workspace, "a");
        WorkflowJob p = (WorkflowJob)this.rule.jenkins.createProject(WorkflowJob.class, "pipeline");
        String script = "node('slave0') {\ncheckout([$class: 'MercurialSCM', credentialsId: '', installation: 'mercurial', source: '" + String.valueOf(workspace) + "'])\n}";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        this.rule.assertBuildStatus(Result.SUCCESS, (Future)p.scheduleBuild2(0, new Action[0]));
    }

    @Test
    public void checkoutShouldNotAbortWhenSourceIsAlias() throws Exception {
        Assert.assertFalse((String)"Non Remote checkout should be disallowed", (boolean)MercurialSCM.ALLOW_LOCAL_CHECKOUT);
        WorkflowJob p = (WorkflowJob)this.rule.jenkins.createProject(WorkflowJob.class, "pipeline");
        String aliasName = "alias1";
        ((MercurialInstallation.DescriptorImpl)this.rule.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(INSTALLATION, "", "hg", false, false, "", false, "[paths]\n" + aliasName + " = https://www.mercurial-scm.org/repo/hello", null)});
        String script = "node {\ncheckout([$class: 'MercurialSCM', credentialsId: '', installation: 'mercurial', source: '" + aliasName + "'])\n}";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        this.m.hg(new FilePath(this.repo), "init");
        this.m.touchAndCommit(new FilePath(this.repo), "a");
        WorkflowRun run = (WorkflowRun)this.rule.assertBuildStatus(Result.SUCCESS, (Future)p.scheduleBuild2(0, new Action[0]));
        this.rule.assertLogNotContains("Checkout of Mercurial source '" + aliasName + "' aborted because it references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property '" + MercurialSCM.ALLOW_LOCAL_CHECKOUT_PROPERTY + "' to true.", (Run)run);
    }

    @Test
    public void checkoutShouldNotAbortWhenSourceIsAliasPointingToLocalPath() throws Exception {
        Assert.assertFalse((String)"Non Remote checkout should be disallowed", (boolean)MercurialSCM.ALLOW_LOCAL_CHECKOUT);
        WorkflowJob p = (WorkflowJob)this.rule.jenkins.createProject(WorkflowJob.class, "pipeline");
        String aliasName = "alias1";
        ((MercurialInstallation.DescriptorImpl)this.rule.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(INSTALLATION, "", "hg", false, false, "", false, "[paths]\n" + aliasName + " = " + this.repo.getPath(), null)});
        String script = "node {\ncheckout([$class: 'MercurialSCM', credentialsId: '', installation: 'mercurial', source: 'alias1'])\n}";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        this.m.hg(new FilePath(this.repo), "init");
        this.m.touchAndCommit(new FilePath(this.repo), "a");
        this.rule.assertBuildStatus(Result.SUCCESS, (Future)p.scheduleBuild2(0, new Action[0]));
    }
}

