/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.Launcher;
import hudson.Proc;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.LabelAxis;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.scm.SCM;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PretendSlave;
import org.jvnet.hudson.test.TestBuilder;

public class MatrixProjectTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @Rule
    public TemporaryFolder tmp2 = new TemporaryFolder();
    private File repo;
    private MatrixProject matrixProject;

    @Before
    public void setUp() throws Exception {
        this.repo = this.tmp.getRoot();
        this.createPretendSlave("slave_one");
        this.createPretendSlave("slave_two");
        this.matrixProject = (MatrixProject)this.j.createProject(MatrixProject.class, "matrix_test");
        this.matrixProject.setScm((SCM)new MercurialSCM(null, this.repo.getPath(), null, null, null, null, false));
        this.matrixProject.setAxes(new AxisList(new Axis[]{new LabelAxis("label", Arrays.asList("slave_one", "slave_two"))}));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
    }

    @Test
    public void allRunsBuildSameRevisionOnClone() throws Exception {
        this.assertAllMatrixRunsBuildSameMercurialRevision();
    }

    @Test
    public void allRunsBuildSameRevisionOnUpdate() throws Exception {
        this.j.assertBuildStatusSuccess((Future)this.matrixProject.scheduleBuild2(0));
        this.m.touchAndCommit(this.repo, "ab");
        this.assertAllMatrixRunsBuildSameMercurialRevision();
    }

    private void assertAllMatrixRunsBuildSameMercurialRevision() throws Exception {
        Node slaveTwo = this.j.jenkins.getNode("slave_two");
        slaveTwo.toComputer().setTemporarilyOffline(true, null);
        final CountDownLatch firstBuild = new CountDownLatch(1);
        this.matrixProject.getBuildersList().add((Object)new TestBuilder(this){
            final /* synthetic */ MatrixProjectTest this$0;
            {
                this.this$0 = this$0;
            }

            public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
                firstBuild.countDown();
                return true;
            }
        });
        QueueTaskFuture matrixBuildFuture = this.matrixProject.scheduleBuild2(0);
        firstBuild.await(5L, TimeUnit.SECONDS);
        this.m.touchAndCommit(this.repo, "b");
        slaveTwo.toComputer().setTemporarilyOffline(false, null);
        MatrixBuild r = (MatrixBuild)matrixBuildFuture.get();
        this.j.assertBuildStatus(Result.SUCCESS, (Run)r);
        List runs = r.getRuns();
        HashSet<String> builtIds = new HashSet<String>();
        for (MatrixRun run : runs) {
            MercurialTagAction builtRevision = (MercurialTagAction)run.getAction(MercurialTagAction.class);
            String buildId = builtRevision.getId();
            builtIds.add(buildId);
        }
        Assert.assertEquals((String)("All runs should build the same Mercurial revision, but they built " + ((Object)builtIds).toString()), (long)1L, (long)builtIds.size());
    }

    private PretendSlave createPretendSlave(String slaveName) throws Exception {
        PretendSlave slave = new PretendSlave(slaveName, this.tmp2.getRoot().getAbsolutePath(), "", this.j.createComputerLauncher(null), (FakeLauncher)new NoopFakeLauncher());
        this.j.jenkins.addNode((Node)slave);
        return slave;
    }

    private static class NoopFakeLauncher
    implements FakeLauncher {
        private NoopFakeLauncher() {
        }

        public Proc onLaunch(Launcher.ProcStarter p) throws IOException {
            return null;
        }
    }
}

