/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.AbstractBuild;
import hudson.model.FreeStyleProject;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import java.io.File;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class DisableChangeLogTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private File repo;
    private static final String DISABLE_CHANGELOG_INSTALLATION = "changelog";

    @Before
    public void setUp() throws Exception {
        this.repo = this.tmp.getRoot();
        ((MercurialInstallation.DescriptorImpl)this.j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(DISABLE_CHANGELOG_INSTALLATION, "", "hg", true, false, false, Collections.emptyList())});
    }

    protected String hgInstallation() {
        return DISABLE_CHANGELOG_INSTALLATION;
    }

    @Test
    public void changelogIsDisabled() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.BRANCH, null, null, null, null, false, null, true));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertTrue((boolean)b.getChangeSet().isEmptySet());
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertTrue((boolean)b.getChangeSet().isEmptySet());
    }
}

