/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialChangeLogParserTest;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialChangeSetList;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import org.jenkinsci.test.acceptance.docker.DockerClassRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.For;
import org.jvnet.hudson.test.JenkinsRule;

@RunWith(value=Parameterized.class)
@For(value={MercurialChangeSet.class, MercurialChangeLogParser.class})
public class ChangelogTest {
    @Rule
    public final JenkinsRule j = new JenkinsRule();
    @Rule
    public final MercurialRule m = new MercurialRule(this.j);
    @ClassRule
    public static final DockerClassRule<MercurialContainer> docker = new DockerClassRule(MercurialContainer.class);
    @ClassRule
    public static final BuildWatcher buildWatcher = new BuildWatcher();
    @Parameterized.Parameter(value=0)
    public MercurialContainer.Version mercurialVersion;
    private FilePath repo;
    private Slave slave;
    private MercurialInstallation inst;

    @Parameterized.Parameters
    public static Object[] data() {
        return MercurialContainer.Version.values();
    }

    @Before
    public void setUp() throws Exception {
        MercurialContainer container = (MercurialContainer)docker.create();
        this.slave = container.createSlave(this.j);
        this.inst = container.createInstallation(this.j, this.mercurialVersion, false, false, false, "", this.slave);
        this.repo = this.slave.getRootPath().child("repo");
        this.repo.mkdirs();
        this.m.withNode((Node)this.slave);
        this.m.withInstallation(this.inst);
    }

    @Test
    public void spacesInPaths() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        MercurialSCM scm = new MercurialSCM(this.repo.getRemote());
        scm.setInstallation(this.inst.getName());
        p.setScm((SCM)scm);
        p.setAssignedNode((Node)this.slave);
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "one", "two");
        ChangelogTest.assertChangelog("", p);
        this.m.touchAndCommit(this.repo, "two", "three");
        ChangelogTest.assertChangelog("added=[three] deleted=[] modified=[two] ", p);
        this.m.hg(this.repo, "rm", "one", "three");
        this.m.hg(this.repo, "commit", "--message", "removed");
        ChangelogTest.assertChangelog("added=[] deleted=[one, three] modified=[] ", p);
        this.m.touchAndCommit(this.repo, "some -> thing");
        ChangelogTest.assertChangelog("added=[some -> thing] deleted=[] modified=[] ", p);
        this.m.touchAndCommit(this.repo, "some -> thing", "two");
        ChangelogTest.assertChangelog("added=[] deleted=[] modified=[some -> thing, two] ", p);
        this.m.hg(this.repo, "rm", "some -> thing");
        this.m.hg(this.repo, "commit", "--message", "removed");
        ChangelogTest.assertChangelog("added=[] deleted=[some -> thing] modified=[] ", p);
    }

    private static void assertChangelog(String summary, FreeStyleProject p) throws Exception {
        Assert.assertEquals((Object)summary, (Object)MercurialChangeLogParserTest.summary((MercurialChangeSetList)((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet()));
    }
}

