/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.ChangeComparator;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;

public class ChangeComparatorTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void triggersNewBuild() throws Exception {
        StreamTaskListener listener = new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset());
        Launcher launcher = this.j.jenkins.createLauncher((TaskListener)listener);
        FreeStyleProject project = this.j.createFreeStyleProject();
        MercurialSCM scm = new MercurialSCM(null, this.tmp.getRoot().getPath(), null, null, null, null, false, null);
        project.setScm((SCM)scm);
        File repo = this.tmp.getRoot();
        this.m.hg(repo, "init");
        this.m.touchAndCommit(repo, "x");
        PollingResult pr = scm.compare(launcher, (TaskListener)listener, new MercurialTagAction("tip", "", null, null), listener.getLogger(), (Node)this.j.jenkins, new FilePath(this.tmp.getRoot()), (Job)project);
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
    }

    @TestExtension(value={"triggersNewBuild"})
    public static class DummyComparator
    extends ChangeComparator {
        public PollingResult.Change compare(MercurialSCM scm, Launcher launcher, TaskListener listener, MercurialTagAction baseline, PrintStream output, Node node, FilePath repository, AbstractProject<?, ?> project) throws IOException, InterruptedException {
            return PollingResult.Change.SIGNIFICANT;
        }
    }
}

