/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RestrictedSince;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.Cache;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMBuilder;
import hudson.plugins.mercurial.MercurialSCMSourceContext;
import hudson.plugins.mercurial.MercurialSCMSourceRequest;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.traits.CleanMercurialSCMSourceTrait;
import hudson.plugins.mercurial.traits.MercurialBrowserSCMSourceTrait;
import hudson.plugins.mercurial.traits.MercurialInstallationSCMSourceTrait;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.RegexSCMHeadFilterTrait;
import jenkins.scm.impl.trait.Selection;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class MercurialSCMSource
extends SCMSource {
    @NonNull
    private final String source;
    @CheckForNull
    private String credentialsId;
    @NonNull
    private List<SCMSourceTrait> traits;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    private transient String installation;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    private transient String branchPattern;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    private transient HgBrowser browser;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    private transient boolean clean;

    @DataBoundConstructor
    public MercurialSCMSource(String source) {
        this.source = source;
        this.traits = new ArrayList<SCMSourceTrait>();
    }

    @Deprecated
    public MercurialSCMSource(String id, String source) {
        this(source);
        this.setId(id);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    public MercurialSCMSource(String id, String installation, String source, String credentialsId, String branchPattern, String modules, String subdir, HgBrowser browser, boolean clean) {
        super(id);
        this.source = source;
        this.credentialsId = credentialsId;
        ArrayList<Object> traits = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)branchPattern) && !".*".equals(branchPattern) && !".+".equals(branchPattern)) {
            traits.add(new RegexSCMHeadFilterTrait(branchPattern));
        }
        if (clean) {
            traits.add((Object)new CleanMercurialSCMSourceTrait());
        }
        if (installation != null) {
            traits.add((Object)new MercurialInstallationSCMSourceTrait(installation));
        }
        if (browser != null) {
            traits.add((Object)new MercurialBrowserSCMSourceTrait(browser));
        }
        this.traits = SCMTrait.asSetList(traits);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Object readResolve() throws ObjectStreamException {
        if (this.traits == null) {
            ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
            if (this.branchPattern != null && StringUtils.isNotBlank((CharSequence)this.branchPattern) && !".*".equals(this.branchPattern) && !".+".equals(this.branchPattern)) {
                traits.add((SCMSourceTrait)new RegexSCMHeadFilterTrait(this.branchPattern));
            }
            if (this.clean) {
                traits.add(new CleanMercurialSCMSourceTrait());
            }
            if (this.installation != null) {
                traits.add(new MercurialInstallationSCMSourceTrait(this.installation));
            }
            if (this.browser != null) {
                traits.add(new MercurialBrowserSCMSourceTrait(this.browser));
            }
            this.setTraits(traits);
        }
        return this;
    }

    @NonNull
    public String getSource() {
        return this.source;
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = SCMTrait.asSetList(traits);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.0")
    public String getInstallation() {
        MercurialInstallationSCMSourceTrait t = (MercurialInstallationSCMSourceTrait)SCMTrait.find(this.traits, MercurialInstallationSCMSourceTrait.class);
        return t != null ? t.getInstallation() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.0")
    public String getBranchPattern() {
        RegexSCMHeadFilterTrait t = (RegexSCMHeadFilterTrait)SCMTrait.find(this.traits, RegexSCMHeadFilterTrait.class);
        return t != null ? t.getRegex() : "";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.0")
    public String getModules() {
        return "";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.0")
    public String getSubdir() {
        return "";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.0")
    public HgBrowser getBrowser() {
        MercurialBrowserSCMSourceTrait t = (MercurialBrowserSCMSourceTrait)SCMTrait.find(this.traits, MercurialBrowserSCMSourceTrait.class);
        return t != null ? t.getBrowser() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.0")
    public boolean isClean() {
        return SCMTrait.find(this.traits, CleanMercurialSCMSourceTrait.class) != null;
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (MercurialSCMSourceRequest request = ((MercurialSCMSourceContext)new MercurialSCMSourceContext(criteria, observer).withCredentialsId(this.credentialsId).withTraits(this.traits)).newRequest(this, listener);){
            MercurialInstallation inst = MercurialSCM.findInstallation(request.installation());
            if (inst == null) {
                throw new AbortException("No configured Mercurial installation");
            }
            if (!inst.isUseCaches()) {
                throw new AbortException("Mercurial installation " + request.installation() + " does not support caches");
            }
            Jenkins node = Jenkins.getInstance();
            Launcher launcher = node.createLauncher(listener);
            StandardUsernameCredentials credentials = this.getCredentials(request.credentialsId(), (Item)this.getOwner());
            final FilePath cache = Cache.fromURL(request.source(), credentials, inst.getMasterCacheRoot()).repositoryCache(inst, (Node)node, launcher, listener, true);
            if (cache == null) {
                throw new AbortException("Could not use caches, not fetching branch heads");
            }
            try (final HgExe hg = new HgExe(inst, credentials, launcher, (Node)node, listener, new EnvVars());){
                String heads = hg.popen(cache, listener, true, new ArgumentListBuilder(new String[]{"heads", "--template", "{node} {branch}\\n"}));
                int count = 0;
                for (String line : heads.split("\r?\n")) {
                    final String[] nodeBranch = line.split(" ", 2);
                    final String name = nodeBranch[1];
                    ++count;
                    if (!request.process(new SCMHead(name), (SCMSourceRequest.RevisionLambda)new SCMSourceRequest.RevisionLambda<SCMHead, MercurialRevision>(){
                        final /* synthetic */ MercurialSCMSource this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @NonNull
                        public MercurialRevision create(@NonNull SCMHead branch) {
                            return new MercurialRevision(branch, nodeBranch[0]);
                        }
                    }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<SCMHead, MercurialRevision>(){
                        final /* synthetic */ MercurialSCMSource this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @NonNull
                        public SCMSourceCriteria.Probe create(@NonNull SCMHead branch, @Nullable MercurialRevision revision) {
                            return new SCMProbeImpl(hg, cache, listener, revision, name);
                        }
                    }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){
                        final /* synthetic */ MercurialSCMSource this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void record(@NonNull SCMHead branch, SCMRevision revision, boolean isMatch) {
                            if (revision == null) {
                                listener.getLogger().println("Ignored branch " + branch.getName());
                            } else {
                                listener.getLogger().println("Found branch " + branch.getName());
                                if (isMatch) {
                                    listener.getLogger().println("  Met criteria");
                                } else {
                                    listener.getLogger().println("  Does not meet criteria");
                                }
                            }
                        }
                    }})) continue;
                    listener.getLogger().format("Processed %d branches (query complete)%n", count);
                    return;
                }
                listener.getLogger().format("Processed %d branches%n", count);
            }
        }
    }

    @CheckForNull
    protected SCMRevision retrieve(@NonNull String thingName, @NonNull TaskListener listener, @CheckForNull Item context) throws IOException, InterruptedException {
        try (MercurialSCMSourceRequest request = ((MercurialSCMSourceContext)new MercurialSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withCredentialsId(this.credentialsId).withTraits(this.traits)).newRequest(this, listener);){
            String revision;
            HgExe hg;
            block16: {
                SCMRevision sCMRevision;
                MercurialInstallation inst = MercurialSCM.findInstallation(request.installation());
                if (inst == null) {
                    throw new AbortException("No configured Mercurial installation");
                }
                if (!inst.isUseCaches()) {
                    throw new AbortException("Mercurial installation " + request.installation() + " does not support caches");
                }
                Jenkins node = Jenkins.getInstance();
                Launcher launcher = node.createLauncher(listener);
                StandardUsernameCredentials credentials = this.getCredentials(request.credentialsId(), context);
                FilePath cache = Cache.fromURL(this.source, credentials, inst.getMasterCacheRoot()).repositoryCache(inst, (Node)node, launcher, listener, true);
                if (cache == null) {
                    throw new AbortException("Could not use caches, not fetching revision");
                }
                hg = new HgExe(inst, credentials, launcher, (Node)node, listener, new EnvVars());
                try {
                    revision = hg.popen(cache, listener, true, new ArgumentListBuilder(new String[]{"log", "-r", "present(" + thingName + ")", "--template", "{node} {branch}"}));
                    if (!revision.isEmpty()) break block16;
                    sCMRevision = null;
                }
                catch (Throwable throwable) {
                    try {
                        hg.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                hg.close();
                return sCMRevision;
            }
            String hash = revision.substring(0, revision.indexOf(32));
            String branch = revision.substring(revision.indexOf(32) + 1, revision.length());
            MercurialRevision mercurialRevision = new MercurialRevision(new SCMHead(branch), hash);
            hg.close();
            return mercurialRevision;
        }
    }

    @NonNull
    protected MercurialSCMBuilder<?> newBuilder(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        return new MercurialSCMBuilder(head, revision, this.source, this.credentialsId);
    }

    protected void decorate(@NonNull MercurialSCMBuilder<?> builder) {
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        MercurialSCMBuilder builder = (MercurialSCMBuilder)this.newBuilder(head, revision).withTraits(this.traits);
        this.decorate(builder);
        return builder.build();
    }

    @CheckForNull
    private StandardUsernameCredentials getCredentials(@CheckForNull String credentialsId, @CheckForNull Item context) {
        if (credentialsId != null) {
            for (StandardUsernameCredentials standardUsernameCredentials : MercurialSCMSource.availableCredentials(context, this.source)) {
                if (!standardUsernameCredentials.getId().equals(credentialsId)) continue;
                return standardUsernameCredentials;
            }
        }
        return null;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if ("default".equals(head.getName())) {
            return Collections.singletonList(new PrimaryInstanceMetadataAction());
        }
        return Collections.emptyList();
    }

    @NonNull
    private static List<? extends StandardUsernameCredentials> availableCredentials(@CheckForNull Item context, @CheckForNull String source) {
        return CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, null, (List)URIRequirementBuilder.fromUri((String)source).build());
    }

    public static final class MercurialRevision
    extends SCMRevision {
        @NonNull
        private final String hash;

        public MercurialRevision(@NonNull SCMHead branch, @NonNull String hash) {
            super(branch);
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof MercurialRevision && ((MercurialRevision)((Object)obj)).hash.equals(this.hash);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public String toString() {
            return this.getHead().getName() + ":" + this.hash;
        }

        @NonNull
        public String getHash() {
            return this.hash;
        }
    }

    private static class SCMProbeImpl
    extends SCMProbe {
        private static final long serialVersionUID = 1L;
        private final transient HgExe hg;
        private final FilePath cache;
        private final TaskListener listener;
        private final MercurialRevision revision;
        private final String name;

        public SCMProbeImpl(HgExe hg, FilePath cache, TaskListener listener, MercurialRevision revision, String name) {
            this.hg = hg;
            this.cache = cache;
            this.listener = listener;
            this.revision = revision;
            this.name = name;
        }

        @NonNull
        public SCMProbeStat stat(@NonNull String path) throws IOException {
            try {
                return SCMProbeStat.fromType((SCMFile.Type)(this.hg.run("locate", "-r", this.revision.getHash(), "-I", "path:" + path).pwd(this.cache).join() == 0 ? SCMFile.Type.REGULAR_FILE : SCMFile.Type.NONEXISTENT));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void close() throws IOException {
        }

        public String name() {
            return this.name;
        }

        public long lastModified() {
            return 0L;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return "Mercurial";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner owner, @QueryParameter String source) {
            if (!this.hasAccessToCredentialsMetadata(owner)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll(MercurialSCMSource.availableCredentials((Item)owner, source));
        }

        private boolean hasAccessToCredentialsMetadata(SCMSourceOwner owner) {
            if (owner == null) {
                return Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER);
            }
            return owner.hasPermission(Item.EXTENDED_READ);
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.0")
        public FormValidation doCheckBranchPattern(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException x) {
                return FormValidation.error((String)x.getDescription());
            }
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.0")
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return RepositoryBrowsers.filter(HgBrowser.class);
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            List all = SCMSourceTrait._for((SCMSourceDescriptor)this, MercurialSCMSourceContext.class, MercurialSCMBuilder.class);
            ArrayList result = new ArrayList();
            NamedArrayList.select((List)all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select((List)all, (String)"Additional", null, (boolean)true, result);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Collections.emptyList();
        }
    }
}

