/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMBuilder;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.MercurialSCMSourceContext;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.traits.Messages;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import java.util.List;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class MercurialBrowserSCMSourceTrait
extends SCMSourceTrait {
    @CheckForNull
    private final HgBrowser browser;

    @DataBoundConstructor
    public MercurialBrowserSCMSourceTrait(@CheckForNull HgBrowser browser) {
        this.browser = browser;
    }

    @CheckForNull
    public HgBrowser getBrowser() {
        return this.browser;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((MercurialSCMBuilder)builder).withBrowser(this.browser);
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.MercurialBrowserSCMSourceTrait_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return RepositoryBrowsers.filter(HgBrowser.class);
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return MercurialSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return MercurialSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return MercurialSCMSource.class;
        }

        public Class<? extends SCM> getScmClass() {
            return MercurialSCM.class;
        }
    }
}

