/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.net.URI;

public class MercurialCommitPayload
implements Serializable {
    @NonNull
    private final URI url;
    @NonNull
    private final String branch;
    @NonNull
    private final String changesetId;

    public MercurialCommitPayload(@NonNull URI url, @NonNull String branch, @NonNull String commitId) {
        this.url = url;
        this.branch = branch;
        this.changesetId = commitId;
    }

    @NonNull
    public URI getUrl() {
        return this.url;
    }

    @NonNull
    public String getBranch() {
        return this.branch;
    }

    @NonNull
    public String getChangesetId() {
        return this.changesetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MercurialCommitPayload that = (MercurialCommitPayload)o;
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!this.branch.equals(that.branch)) {
            return false;
        }
        return this.changesetId.equals(that.changesetId);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.branch.hashCode();
        result = 31 * result + this.changesetId.hashCode();
        return result;
    }

    public String toString() {
        return "MercurialCommitPayload{url='" + String.valueOf(this.url) + "', branch='" + this.branch + "', commitId='" + this.changesetId + "'}";
    }
}

