/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.plugins.mercurial.browser.AbstractBrowserTestBase;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.RhodeCode;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RhodeCodeTest
extends AbstractBrowserTestBase {
    private static final String REPO_URL = "https://secure.rhodecode.org/rhodecode";

    RhodeCodeTest() {
    }

    @Override
    protected HgBrowser getBrowser() throws Exception {
        return new RhodeCode(REPO_URL);
    }

    @Test
    void testGetFileLink() throws Exception {
        String expected = "https://secure.rhodecode.org/rhodecode/files/6704efde87541766fadba17f66d04b926cd4d343/rhodecode/public/css/pygments.css";
        this.browser.getChangeSetLink(this.changeSet);
        Assertions.assertEquals((Object)expected, (Object)this.browser.getFileLink("rhodecode/public/css/pygments.css").toExternalForm());
    }

    @Test
    void testGetDiffLink() throws Exception {
        String expected = "https://secure.rhodecode.org/rhodecode/changeset/6704efde87541766fadba17f66d04b926cd4d343#Crhodecode-public-css-pygments.css";
        this.browser.getChangeSetLink(this.changeSet);
        Assertions.assertEquals((Object)expected, (Object)this.browser.getDiffLink("rhodecode/public/css/pygments.css").toExternalForm());
    }

    @Test
    void testGetChangeSetLinkMercurialChangeSet() throws IOException {
        String expected = "https://secure.rhodecode.org/rhodecode/changeset/6704efde87541766fadba17f66d04b926cd4d343";
        Assertions.assertEquals((Object)expected, (Object)this.browser.getChangeSetLink(this.changeSet).toExternalForm());
    }
}

