/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.browser.GoogleCode;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.jvnet.hudson.test.recipes.LocalData;

@WithJenkins
class HgBrowserSelectionTest {
    private JenkinsRule j;

    HgBrowserSelectionTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.j = rule;
    }

    @LocalData
    @Test
    void repositoryBrowserCompatibility() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.j.jenkins.getItem("foo");
        MercurialSCM ms = (MercurialSCM)p.getScm();
        RepositoryBrowser browser = ms.getEffectiveBrowser();
        Assertions.assertInstanceOf(HgWeb.class, (Object)browser, (String)String.valueOf(browser));
        this.j.assertEqualBeans((Object)new HgWeb("http://www.yahoo.com/"), (Object)browser, "url");
    }

    @LocalData
    @Test
    void pickingUpAlternativeBrowser() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.j.jenkins.getItem("foo");
        MercurialSCM ms = (MercurialSCM)p.getScm();
        HgBrowser browser = ms.getBrowser();
        Assertions.assertEquals((Object)"http://code.google.com/p/xxx/source/", (Object)browser.getUrl().toString(), (String)"wrong url");
        Assertions.assertInstanceOf(GoogleCode.class, (Object)browser, (String)("class:" + String.valueOf(browser.getClass())));
        this.j.assertEqualBeans((Object)new GoogleCode("http://code.google.com/p/xxx/source/"), (Object)browser, "url");
    }

    @LocalData
    @Test
    void browsersAvailableInDropDown() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.j.jenkins.getItem("foo");
        MercurialSCM ms = (MercurialSCM)p.getScm();
        HgBrowser browser = ms.getBrowser();
        Assertions.assertEquals((Object)"http://code.google.com/p/xxx/source/", (Object)browser.getUrl().toString(), (String)"wrong url");
        Assertions.assertInstanceOf(GoogleCode.class, (Object)browser, (String)("class:" + String.valueOf(browser.getClass())));
        this.j.assertEqualBeans((Object)new GoogleCode("http://code.google.com/p/xxx/source/"), (Object)browser, "url");
        List browserDescriptors = ms.getDescriptor().getBrowserDescriptors();
        Assertions.assertTrue((boolean)browserDescriptors.contains(browser.getDescriptor()), (String)("Could not find GoogleCode in " + String.valueOf(browserDescriptors)));
    }

    @Test
    void configureBrowser() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(null, "https://host/repo", null, null, null, (HgBrowser)new HgWeb("https://host/repo"), false, null));
        this.j.configRoundtrip((Item)p);
        Assertions.assertEquals((Object)"https://host/repo/", (Object)((MercurialSCM)p.getScm()).getBrowser().getUrl().toString());
    }
}

