/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.plugins.mercurial.browser.AbstractBrowserTestBase;
import hudson.plugins.mercurial.browser.GoogleCode;
import hudson.plugins.mercurial.browser.HgBrowser;
import java.net.MalformedURLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GoogleCodeTest
extends AbstractBrowserTestBase {
    private static final String REPO_URL = "http://code.google.com/p/PROJECTNAME/source";

    GoogleCodeTest() {
    }

    @Override
    protected HgBrowser getBrowser() throws Exception {
        return new GoogleCode(REPO_URL);
    }

    @Test
    void testGetChangeSetLinkMercurialChangeSet() throws Exception {
        this.testGetChangeSetLinkMercurialChangeSet("http://code.google.com/p/PROJECTNAME/source/detail?r=6704efde87541766fadba17f66d04b926cd4d343");
    }

    @Test
    void testGetFileLink() throws Exception {
        this.testGetFileLink("http://code.google.com/p/PROJECTNAME/source/browse/src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java?spec=svn6704efde87541766fadba17f66d04b926cd4d343&r=6704efde87541766fadba17f66d04b926cd4d343");
    }

    @Test
    void testGetDiffLink() throws Exception {
        this.testGetDiffLink("http://code.google.com/p/PROJECTNAME/source/diff?spec=svn6704efde87541766fadba17f66d04b926cd4d343&r=6704efde87541766fadba17f66d04b926cd4d343&format=unidiff&path=%2Fsrc%2Fmain%2Fjava%2Fhudson%2Fplugins%2Fmercurial%2Fbrowser%2FHgBrowser.java");
    }

    @Test
    void testGoogleCode() {
        Assertions.assertEquals((Object)"http://code.google.com/p/PROJECTNAME/source/", (Object)this.browser.getUrl().toExternalForm());
    }

    @Test
    void testGoogleCodeMustEndWithSource() {
        Assertions.assertThrows(MalformedURLException.class, () -> new GoogleCode("http://code.google.com/p/PROJECTNAME"));
    }
}

