/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class SwitchingSCMTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;
    private File repo;
    private static final String CACHING_INSTALLATION = "caching";
    private static final String SHARING_INSTALLATION = "sharing";

    SwitchingSCMTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.repo = this.tmp;
        ((MercurialInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(CACHING_INSTALLATION, "", "hg", false, true, false, Collections.emptyList())});
        ((MercurialInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(SHARING_INSTALLATION, "", "hg", false, true, true, Collections.emptyList())});
    }

    @Test
    void switchingFromCachedToShared() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(CACHING_INSTALLATION, this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        this.m.buildAndCheck(p, "a", new Action[0]);
        Assertions.assertFalse((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
        p.setScm((SCM)new MercurialSCM(SHARING_INSTALLATION, this.repo.getPath(), null, null, null, null, false));
        this.m.touchAndCommit(this.repo, "b");
        this.m.buildAndCheck(p, "b", new Action[0]);
        Assertions.assertTrue((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
    }

    @Test
    void testSwitchingFromSharedToCached() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(SHARING_INSTALLATION, this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        this.m.buildAndCheck(p, "a", new Action[0]);
        Assertions.assertTrue((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
        p.setScm((SCM)new MercurialSCM(CACHING_INSTALLATION, this.repo.getPath(), null, null, null, null, false));
        this.m.touchAndCommit(this.repo, "b");
        this.m.buildAndCheck(p, "b", new Action[0]);
        Assertions.assertFalse((boolean)p.getSomeWorkspace().child(".hg").child("sharedpath").exists());
    }
}

