/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.slaves.DumbSlave;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.opentest4j.TestAbortedException;

@WithJenkins
abstract class SCMTestBase {
    protected JenkinsRule j;
    protected MercurialTestUtil m;
    @TempDir
    protected File tmp;
    @RegisterExtension
    protected static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private File repo;

    SCMTestBase() {
    }

    @BeforeAll
    static void beforeAll() throws Exception {
        try {
            if (new ProcessBuilder("hg", "--version").start().waitFor() != 0) {
                throw new TestAbortedException("hg --version signaled an error");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (message.startsWith("Cannot run program \"hg\"") && message.endsWith("No such file or directory")) {
                throw new TestAbortedException("hg is not available; please check that your PATH environment variable is properly configured");
            }
            throw new TestAbortedException(ioe.toString());
        }
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.repo = this.tmp;
    }

    @CheckForNull
    protected abstract String hgInstallation();

    protected void assertClone(String log, boolean cloneExpected) {
        if (cloneExpected) {
            Assertions.assertTrue((boolean)log.contains(" clone --"), (String)log);
        } else {
            Assertions.assertTrue((boolean)log.contains(" update --"), (String)log);
            Assertions.assertFalse((boolean)log.contains(" clone --"), (String)log);
        }
    }

    @Test
    void pollingLimitedToModules() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1 dir2", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f");
        this.m.buildAndCheck(p, "dir1/f", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir2/f");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir2/f", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir3/f");
        pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir3/f", new Action[0]);
    }

    @Test
    void pollingLimitedToModules2() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir2/f");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
        this.m.touchAndCommit(this.repo, "dir1/f");
        pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir1/f", new Action[0]);
    }

    @Test
    void pollingLimitedToModules3() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1/f", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir1/g");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
        this.m.touchAndCommit(this.repo, "dir1/f");
        pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir1/f", new Action[0]);
    }

    @Test
    void pollingIgnoresMetaFiles() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f");
        this.m.buildAndCheck(p, "f", new Action[0]);
        this.m.hg(this.repo, "tag", "mystuff");
        Assertions.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)this.m.pollSCMChanges((FreeStyleProject)p).change);
    }

    @Test
    void pollingHonorsBranchMerges() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "feature");
        this.m.hg(this.repo, "update", "default");
        this.m.hg(this.repo, "merge", "b");
        this.m.hg(this.repo, "commit", "--message", "merged");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "feature", new Action[0]);
    }

    @Test
    void pollingHonorsBranchMergesWithModules() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "mod1", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.hg(this.repo, "branch", "mod1dev");
        this.m.touchAndCommit(this.repo, "mod1/feature");
        this.m.hg(this.repo, "update", "default");
        this.m.hg(this.repo, "merge", "mod1dev");
        this.m.hg(this.repo, "commit", "--message", "merged");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "mod1/feature", new Action[0]);
        this.m.hg(this.repo, "branch", "mod2dev");
        this.m.touchAndCommit(this.repo, "mod2/feature");
        this.m.hg(this.repo, "update", "default");
        this.m.hg(this.repo, "merge", "mod2dev");
        this.m.hg(this.repo, "commit", "--message", "merged");
        pr = this.m.pollSCMChanges(p);
        Assertions.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
    }

    @Test
    void changelogLimitedToModules() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        p.scheduleBuild2(0).get();
        this.m.touchAndCommit(this.repo, "dir2/f1");
        Iterator it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertEquals(Collections.singleton("dir2/f1"), new HashSet(entry.getAffectedPaths()));
        Assertions.assertFalse((boolean)it.hasNext());
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1 extra", null, null, false));
        this.m.touchAndCommit(this.repo, "dir1/f2");
        this.m.touchAndCommit(this.repo, "dir2/f2");
        it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertEquals(Collections.singleton("dir1/f2"), new HashSet(entry.getAffectedPaths()));
        Assertions.assertFalse((boolean)it.hasNext());
        this.m.touchAndCommit(this.repo, "dir2/f3", "dir1/f3");
        this.m.touchAndCommit(this.repo, "dir2/f4", "dir2/f5");
        it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("dir1/f3", "dir2/f3")), new HashSet(entry.getAffectedPaths()));
        Assertions.assertFalse((boolean)it.hasNext());
        this.m.touchAndCommit(this.repo, "extra/f1");
        it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertEquals(Collections.singleton("extra/f1"), new HashSet(entry.getAffectedPaths()));
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void parameterizedBuildsBranch() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "trunk");
        this.m.hg(this.repo, "update", "null");
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "variant");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "${BRANCH}", null, null, null, false));
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("BRANCH", "b")}));
        String log = this.m.buildAndCheck(p, "variant", new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("BRANCH", "b")})});
        Assertions.assertTrue((boolean)log.contains("--rev b"), (String)log);
        Assertions.assertFalse((boolean)log.contains("--rev ${BRANCH}"), (String)log);
        this.m.touchAndCommit(this.repo, "further-variant");
        this.m.buildAndCheck(p, "further-variant", new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("BRANCH", "b")})});
    }

    @Test
    void pollingExpandsParameterDefaults() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "trunk");
        this.m.hg(this.repo, "update", "null");
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "variant");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("branch", "default")}));
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "${branch}", null, null, null, false));
        String log = this.m.buildAndCheck(p, "trunk", new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("branch", "default")})});
        Assertions.assertTrue((boolean)log.contains("--rev default"), (String)log);
        Assertions.assertEquals((Object)PollingResult.Change.NONE, (Object)this.m.pollSCMChanges((FreeStyleProject)p).change);
        this.m.hg(this.repo, "update", "default");
        this.m.touchAndCommit(this.repo, "trunk2");
        Assertions.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)this.m.pollSCMChanges((FreeStyleProject)p).change);
    }

    @Test
    void fileListOmittedForMerges() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        p.scheduleBuild2(0).get();
        this.m.hg(this.repo, "up", "null");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.hg(this.repo, "merge");
        this.m.hg(this.repo, "commit", "--message", "merge");
        Iterator it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertTrue((boolean)((MercurialChangeSet)entry).isMerge());
        Assertions.assertEquals(Collections.emptySet(), new HashSet(entry.getAffectedPaths()));
        Assertions.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertFalse((boolean)((MercurialChangeSet)entry).isMerge());
        Assertions.assertEquals(Collections.singleton("f2"), new HashSet(entry.getAffectedPaths()));
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void changesMergedToRenamedModulesTriggerBuild() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "alltogether/some_interface", "alltogether/some_class");
        this.m.hg(this.repo, "branch", "stable");
        this.m.touchAndCommit(this.repo, "alltogether/some_class");
        this.m.hg(this.repo, "up", "default");
        this.m.hg(this.repo, "mv", "alltogether/some_interface", "api/some_interface");
        this.m.hg(this.repo, "mv", "alltogether/some_class", "impl/some_class");
        this.m.hg(this.repo, "commit", "--message", "reorganizing repository to properly split api and implementation");
        String reorganizationCommit = this.m.getLastChangesetId(this.repo);
        FreeStyleProject projectForImplModule = this.j.createFreeStyleProject();
        projectForImplModule.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "impl", null, null, false));
        projectForImplModule.scheduleBuild2(0).get();
        this.m.hg(this.repo, "merge", "stable");
        this.m.hg(this.repo, "commit", "--message", "merge changes from stable branch");
        String mergeCommit = this.m.getLastChangesetId(this.repo);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, reorganizationCommit, mergeCommit, this.m.pollSCMChanges(projectForImplModule));
    }

    @Test
    void subdirectoryCheckout() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, "repo", null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.buildAndCheck(p, "repo/f1", new Action[0]);
        this.m.touchAndCommit(this.repo, "f2");
        this.m.buildAndCheck(p, "repo/f2", new Action[0]);
        this.m.touchAndCommit(this.repo, "f3");
        Iterator it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertEquals(Collections.singleton("f3"), new HashSet(entry.getAffectedPaths()));
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void clean() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, true));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.buildAndCheck(p, "f1", new Action[0]);
        FilePath ws = ((FreeStyleBuild)p.getLastBuild()).getWorkspace();
        ws.child("junk1").write("junk", null);
        ws.child("junk2").write("junk", null);
        this.m.hg(new File(ws.getRemote()), "add", "junk2");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.buildAndCheck(p, "f2", new Action[0]);
        TreeSet<String> kids = new TreeSet<String>();
        for (FilePath kid : ws.list()) {
            kids.add(kid.getName());
        }
        Assertions.assertEquals((Object)"[.hg, f1, f2]", (Object)((Object)kids).toString());
    }

    @Test
    void multipleProjectsForSingleSource() throws Exception {
        FreeStyleProject one = this.j.createFreeStyleProject();
        FreeStyleProject two = this.j.createFreeStyleProject();
        FreeStyleProject three = this.j.createFreeStyleProject();
        FreeStyleProject four = this.j.createFreeStyleProject();
        one.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        two.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        three.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "b", null, null, null, false));
        four.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "b", null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        Assertions.assertTrue((boolean)this.m.pollSCMChanges(one).hasChanges());
        this.m.buildAndCheck(one, "f1", new Action[0]);
        Assertions.assertTrue((boolean)this.m.pollSCMChanges(two).hasChanges());
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "b1");
        Assertions.assertFalse((boolean)this.m.pollSCMChanges(one).hasChanges());
        this.m.buildAndCheck(three, "b1", new Action[0]);
        this.m.buildAndCheck(four, "b1", new Action[0]);
        this.m.touchAndCommit(this.repo, "b2");
        Assertions.assertTrue((boolean)this.m.pollSCMChanges(three).hasChanges());
        this.m.buildAndCheck(three, "b2", new Action[0]);
        Assertions.assertTrue((boolean)this.m.pollSCMChanges(four).hasChanges());
        Assertions.assertFalse((boolean)this.m.pollSCMChanges(one).hasChanges());
    }

    @Test
    void changelogOnUpdate() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertTrue((boolean)b.getChangeSet().isEmptySet());
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir2/f1")), b);
        this.m.touchAndCommit(this.repo, "dir3/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir3/f1")), b);
    }

    @Test
    void changelogOnClone() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertTrue((boolean)b.getChangeSet().isEmptySet());
        b.getWorkspace().deleteRecursive();
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir2/f1")), b);
        b.getWorkspace().deleteRecursive();
        this.m.touchAndCommit(this.repo, "dir3/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir3/f1")), b);
    }

    @Test
    void changelogFromPreviousBuild() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        DumbSlave s1 = this.j.createOnlineSlave();
        DumbSlave s2 = this.j.createOnlineSlave();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        p.setAssignedNode((Node)s1);
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertTrue((boolean)b.getChangeSet().isEmptySet());
        p.setAssignedNode((Node)s2);
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        p.setAssignedNode((Node)s1);
        this.m.touchAndCommit(this.repo, "dir3/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir3/f1")), b);
    }

    @Test
    void polling() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        p.setAssignedLabel(null);
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        String cs1 = this.m.getLastChangesetId(this.repo);
        PollingResult pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.INCOMPARABLE, null, null, pr);
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.NONE, cs1, cs1, pr);
        this.m.touchAndCommit(this.repo, "f2");
        String cs2 = this.m.getLastChangesetId(this.repo);
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, cs1, cs2, pr);
        b.getWorkspace().deleteRecursive();
        pr = this.m.pollSCMChanges(p);
        if (p.getScm().requiresWorkspaceForPolling()) {
            this.assertPollingResult(PollingResult.Change.INCOMPARABLE, null, null, pr);
        } else {
            this.assertPollingResult(PollingResult.Change.NONE, cs2, cs2, pr);
        }
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.m.touchAndCommit(this.repo, "f3");
        this.m.touchAndCommit(this.repo, "f4");
        String cs4 = this.m.getLastChangesetId(this.repo);
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, cs2, cs4, pr);
        this.m.touchAndCommit(this.repo, "f5");
        String cs5 = this.m.getLastChangesetId(this.repo);
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, cs4, cs5, pr);
    }

    @Test
    void trailingUrlWhitespace() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath() + " ", null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertEquals((Object)Result.SUCCESS, (Object)b.getResult());
    }

    @Test
    void nonExistingBranchesDontGenerateMercurialTagActionsInTheBuild() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "non-existing-branch", null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        for (Action action : b.getActions()) {
            if (!(action instanceof MercurialTagAction)) continue;
            Assertions.fail((String)"There should not be any MercurialTagAction");
        }
    }

    @Test
    void tags() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.hg(this.repo, "tag", "release");
        this.m.touchAndCommit(this.repo, "f3");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.TAG, "release", null, null, null, false, null));
        FreeStyleBuild b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assertions.assertTrue((boolean)ws.child("f1").exists());
        Assertions.assertTrue((boolean)ws.child("f2").exists());
        Assertions.assertFalse((boolean)ws.child("f3").exists());
        this.m.hg(this.repo, "tag", "--force", "release");
        b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        Assertions.assertTrue((boolean)ws.child("f3").exists(), (String)JenkinsRule.getLog((Run)b));
    }

    @Test
    void revsets() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.hg(this.repo, "log");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.REVSET, "first(parents(tip))", null, null, null, false, null));
        FreeStyleBuild b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assertions.assertTrue((boolean)ws.child("f1").exists());
        Assertions.assertFalse((boolean)ws.child("f2").exists());
        this.m.hg(this.repo, "update", "-r", "0");
        this.m.touchAndCommit(this.repo, "f3");
        this.m.hg(this.repo, "merge");
        this.m.hg(this.repo, "commit", "-m", "Merged some stuff");
        b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        ws = b.getWorkspace();
        Assertions.assertTrue((boolean)ws.child("f1").exists());
        Assertions.assertTrue((boolean)ws.child("f2").exists());
        Assertions.assertFalse((boolean)ws.child("f3").exists());
        this.m.touchAndCommit(this.repo, "f4");
        b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        ws = b.getWorkspace();
        Assertions.assertTrue((boolean)ws.child("f1").exists());
        Assertions.assertTrue((boolean)ws.child("f2").exists());
        Assertions.assertTrue((boolean)ws.child("f3").exists());
        Assertions.assertFalse((boolean)ws.child("f4").exists());
    }

    private void assertChangeSetPaths(List<? extends Set<String>> expectedChangeSetPaths, AbstractBuild<?, ?> build) throws IOException {
        ChangeLogSet actualChangeLogSet = build.getChangeSet();
        LinkedList actualChangeSetPaths = new LinkedList();
        for (ChangeLogSet.Entry entry : actualChangeLogSet) {
            actualChangeSetPaths.add(new LinkedHashSet(entry.getAffectedPaths()));
        }
        Assertions.assertEquals(expectedChangeSetPaths, actualChangeSetPaths, (String)build.getLog(99).toString());
    }

    private void assertPollingResult(PollingResult.Change expectedChangeDegree, String expectedBaselineId, String expectedRemoteId, PollingResult actualPollingResult) {
        Assertions.assertNotNull((Object)actualPollingResult);
        PollingResult.Change actualChangeDegree = actualPollingResult.change;
        Assertions.assertEquals((Object)expectedChangeDegree, (Object)actualChangeDegree);
        if (expectedBaselineId == null) {
            Assertions.assertNull((Object)actualPollingResult.baseline);
        } else {
            MercurialTagAction actualBaseline = (MercurialTagAction)actualPollingResult.baseline;
            Assertions.assertEquals((Object)expectedBaselineId, (Object)actualBaseline.id);
        }
        if (expectedRemoteId == null) {
            Assertions.assertNull((Object)actualPollingResult.remote);
        } else {
            MercurialTagAction actualRemote = (MercurialTagAction)actualPollingResult.remote;
            Assertions.assertEquals((Object)expectedRemoteId, (Object)actualRemote.id);
        }
    }

    @Test
    void testPullReturnCode() throws Exception {
        File repoOnline = SCMTestBase.newFolder(this.tmp, "junit");
        File repoOffline = new File(repoOnline.getPath() + "-offline");
        this.m.hg(repoOnline, "init");
        this.m.touchAndCommit(repoOnline, "init");
        this.m.hg(repoOnline, "tag", "init");
        FreeStyleProject p = this.j.createFreeStyleProject();
        MercurialSCM a = new MercurialSCM(this.hgInstallation(), repoOnline.getPath(), null, null, null, null, false);
        p.setScm((SCM)a);
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertEquals((Object)Result.SUCCESS, (Object)b.getResult());
        repoOnline.renameTo(repoOffline);
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertNotEquals((Object)Result.SUCCESS, (Object)b.getResult());
        repoOffline.renameTo(repoOnline);
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertEquals((Object)Result.SUCCESS, (Object)b.getResult());
    }

    private void initRepoWithTag() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "init");
        this.m.hg(this.repo, "branch", "stable");
        this.m.touchAndCommit(this.repo, "stable commit");
        this.m.hg(this.repo, "tag", "release");
        this.m.hg(this.repo, "update", "--clean", "default");
    }

    @Test
    void testGetBranchFromTag() throws Exception {
        this.initRepoWithTag();
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.TAG, "release", null, null, null, false, null));
        FreeStyleBuild b = this.j.buildAndAssertSuccess(p);
        MercurialTagAction action = (MercurialTagAction)b.getAction(MercurialTagAction.class);
        Assertions.assertNotNull((Object)action);
        Assertions.assertEquals((Object)"stable", (Object)action.getBranch());
        Assertions.assertEquals((Object)"stable", (Object)b.getEnvironment().get((Object)"MERCURIAL_REVISION_BRANCH"));
    }

    @Test
    void testGetNoBranchFromBranch() throws Exception {
        this.initRepoWithTag();
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.BRANCH, "default", null, null, null, false, null));
        FreeStyleBuild b = this.j.buildAndAssertSuccess(p);
        MercurialTagAction action = (MercurialTagAction)b.getAction(MercurialTagAction.class);
        Assertions.assertNotNull((Object)action);
        Assertions.assertNull((Object)action.getBranch());
        Assertions.assertNull((Object)b.getEnvironment().get((Object)"MERCURIAL_REVISION_BRANCH"));
    }

    @Test
    void testChangeSetApiVersion1407Methods() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        p.scheduleBuild2(0).get();
        this.m.touchAndCommit(this.repo, "f2");
        MercurialChangeSet changeSet = (MercurialChangeSet)((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator().next();
        String commitId = this.m.getLastChangesetId(this.repo);
        long timestampInSeconds = this.m.getLastChangesetUnixTimestamp(this.repo);
        Assertions.assertEquals((Object)commitId, (Object)changeSet.getCommitId());
        Assertions.assertEquals((long)(timestampInSeconds * 1000L), (long)changeSet.getTimestamp());
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + String.valueOf(root));
        }
        return result;
    }

    @Extension
    public static final class ShowChangelogs
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            System.out.println("---%<--- " + String.valueOf(changelogFile));
            FileUtils.copyFile((File)changelogFile, (OutputStream)System.out);
            System.out.println("\n--->%---");
        }
    }

    private static final class NoopFakeLauncher
    implements FakeLauncher {
        private NoopFakeLauncher() {
        }

        public Proc onLaunch(Launcher.ProcStarter p) {
            return null;
        }
    }
}

