/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.htmlunit.Page;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.SleepBuilder;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
@WithJenkins
class MercurialStatusPermissionTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @Container
    private static final MercurialContainer container = new MercurialContainer();
    private final String[] names = new String[]{"one1", "two2", "three3"};
    private final String carls = this.names[1];
    private String source;

    MercurialStatusPermissionTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) throws Exception {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.m.hg("version");
        Slave agent = container.createAgent(this.j);
        this.m.withNode((Node)agent);
        MercurialInstallation inst = container.createInstallation(this.j, MercurialContainer.Version.HG6, false, false, false, "", agent);
        Assertions.assertNotNull((Object)inst);
        this.m.withInstallation(inst);
        FilePath sampleRepo = agent.getRootPath().child("sampleRepo");
        sampleRepo.mkdirs();
        this.m.hg(sampleRepo, "init");
        sampleRepo.child("a").write("a", "UTF-8");
        this.m.hg(sampleRepo, "commit", "--addremove", "--message=a-file");
        this.source = "ssh://test@" + container.getHost() + ":" + container.getMappedPort(22) + "/" + String.valueOf(sampleRepo);
        FreeStyleProject p = this.j.createFreeStyleProject(this.names[0]);
        p.setScm((SCM)new MercurialSCM(inst.getName(), this.source, null, null, null, null, false));
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.getBuildersList().add((Object)new SleepBuilder(1000L));
        FreeStyleProject carls = p = this.j.createFreeStyleProject(this.names[1]);
        p.setScm((SCM)new MercurialSCM(inst.getName(), this.source, null, null, null, null, false));
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.getBuildersList().add((Object)new SleepBuilder(1000L));
        p = this.j.createFreeStyleProject(this.names[2]);
        p.setScm((SCM)new MercurialSCM(inst.getName(), this.source, null, null, null, null, false));
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.getBuildersList().add((Object)new SleepBuilder(1000L));
        this.j.jenkins.setSecurityRealm((SecurityRealm)this.j.createDummySecurityRealm());
        this.j.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Item.READ}).everywhere().to(new String[]{"bob"}).grant(new Permission[]{Item.READ}).onItems(new Item[]{carls}).to(new String[]{"carl"}).grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"alice"}).grant(new Permission[]{Jenkins.READ}).onRoot().toAuthenticated());
    }

    @Test
    void testTriggeredWithAnonymous() throws Exception {
        Page page = this.j.createWebClient().goTo("mercurial/notifyCommit?url=" + this.source, "text/plain");
        WebResponse response = page.getWebResponse();
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        List headers = response.getResponseHeaders();
        List<NameValuePair> triggered = headers.stream().filter(nvp -> nvp.getName().equals("Triggered")).toList();
        Assertions.assertEquals((int)3, (int)triggered.size(), (String)"No headers!");
        List<String> headerValues = triggered.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of a job"));
        MatcherAssert.assertThat((Object)headerValues.toArray(new String[0]), (Matcher)ArrayMatching.hasItemInArray((Matcher)StringContains.containsString((String)"Something")));
        ArrayList<Matcher> testHeaders = new ArrayList<Matcher>();
        for (String name : this.names) {
            MatcherAssert.assertThat((Object)content, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)name)));
            testHeaders.add(IsNot.not((Matcher)StringEndsWith.endsWith((String)(name + "/"))));
        }
        MatcherAssert.assertThat(headerValues, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(testHeaders));
    }

    @Test
    void testTriggeredWithAllReadable() throws Exception {
        Page page = this.j.createWebClient().login("bob").goTo("mercurial/notifyCommit?url=" + this.source, "text/plain");
        WebResponse response = page.getWebResponse();
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        List headers = response.getResponseHeaders();
        List<NameValuePair> triggered = headers.stream().filter(nvp -> nvp.getName().equals("Triggered")).toList();
        Assertions.assertEquals((int)3, (int)triggered.size(), (String)"No headers!");
        List<String> headerValues = triggered.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of"));
        MatcherAssert.assertThat((Object)content, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)"Scheduled polling of a job")));
        MatcherAssert.assertThat((Object)headerValues.toArray(new String[0]), (Matcher)IsNot.not((Matcher)ArrayMatching.hasItemInArray((Matcher)StringContains.containsString((String)"Something"))));
        ArrayList<Matcher> testHeaders = new ArrayList<Matcher>();
        for (String name : this.names) {
            MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)name));
            testHeaders.add(StringEndsWith.endsWith((String)(name + "/")));
        }
        MatcherAssert.assertThat(headerValues, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(testHeaders));
    }

    @Test
    void testTriggeredWithOneReadable() throws Exception {
        Page page = this.j.createWebClient().login("carl").goTo("mercurial/notifyCommit?url=" + this.source, "text/plain");
        WebResponse response = page.getWebResponse();
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        List headers = response.getResponseHeaders();
        List<NameValuePair> triggered = headers.stream().filter(nvp -> nvp.getName().equals("Triggered")).toList();
        Assertions.assertEquals((int)3, (int)triggered.size(), (String)"No headers!");
        List<String> headerValues = triggered.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of"));
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of a job"));
        MatcherAssert.assertThat((Object)headerValues.toArray(new String[0]), (Matcher)ArrayMatching.hasItemInArray((Matcher)StringContains.containsString((String)"Something")));
        ArrayList<Matcher> testHeaders = new ArrayList<Matcher>();
        for (String name : this.names) {
            if (name.equals(this.carls)) {
                MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)name));
                testHeaders.add(StringEndsWith.endsWith((String)(name + "/")));
                continue;
            }
            MatcherAssert.assertThat((Object)content, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)name)));
            testHeaders.add(IsNot.not((Matcher)StringEndsWith.endsWith((String)(name + "/"))));
        }
        MatcherAssert.assertThat(headerValues, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(testHeaders));
    }
}

