/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.Action;
import hudson.model.Actionable;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTagAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MercurialSCMTest {
    MercurialSCMTest() {
    }

    @Test
    void parseStatus() {
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("whatever", "added", "mo-re", "whatever-c", "initial", "more")), (Object)MercurialSCM.parseStatus((String)"M whatever\nA added\nA mo-re\n  more\nA whatever-c\n  whatever\nR initial\nR more\n"));
    }

    @Test
    void buildEnvVarsSetsShortId() {
        HashMap actualEnvironment = new HashMap();
        String EXPECTED_SHORT_ID = "123456789012";
        new MercurialSCM("", "", "", "", "", null, true).buildEnvVarsFromActionable(new Actionable(){

            public List<Action> getActions() {
                return Collections.singletonList(new MercurialTagAction("1234567890121627e63489b4096a8858e559a456", "rev", null, null));
            }

            public String getDisplayName() {
                return null;
            }

            public String getSearchUrl() {
                return null;
            }
        }, actualEnvironment);
        Assertions.assertEquals((Object)"123456789012", actualEnvironment.get("MERCURIAL_REVISION_SHORT"));
    }

    @Test
    void buildEnvVarsSetsUrl() {
        HashMap actualEnvironment = new HashMap();
        String EXPECTED_REPOSITORY_URL = "http://mercurialserver/testrepo";
        new MercurialSCM("", "http://mercurialserver/testrepo", "", "", "", null, true).buildEnvVarsFromActionable(new Actionable(){

            public List<Action> getActions() {
                return Collections.singletonList(new MercurialTagAction("1627e63489b4096a8858e559a456", "rev", null, null));
            }

            public String getDisplayName() {
                return null;
            }

            public String getSearchUrl() {
                return null;
            }
        }, actualEnvironment);
        Assertions.assertEquals((Object)"http://mercurialserver/testrepo", actualEnvironment.get("MERCURIAL_REPOSITORY_URL"));
    }

    @Test
    void abortIfSourceIsLocal() {
        Assertions.assertDoesNotThrow(() -> new MercurialSCM("", "https://mercurialserver/testrepo", "", "", "", null, true).abortIfSourceLocal(), (String)"https source URLs should always be valid");
    }
}

