/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMRevision;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class MercurialSCMSourceTest {
    private static JenkinsRule j;
    private static MercurialTestUtil m;
    @TempDir
    private static File tmp;
    private static LogTaskListener listener;
    private static MercurialSCMSource mercurialSCMSource;

    MercurialSCMSourceTest() {
    }

    @BeforeAll
    static void beforeAll(JenkinsRule rule) throws Exception {
        j = rule;
        m = new MercurialTestUtil(j);
        String instName = "caching";
        MercurialInstallation installation = new MercurialInstallation(instName, "", "hg", false, true, null, false, null, Collections.emptyList());
        listener = new LogTaskListener(Logger.getLogger(MercurialSCMSourceTest.class.getName()), Level.INFO);
        ((MercurialInstallation.DescriptorImpl)MercurialSCMSourceTest.j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{installation});
        FilePath repo = new FilePath(tmp);
        installation.forNode((Node)MercurialSCMSourceTest.j.jenkins, (TaskListener)StreamTaskListener.fromStdout());
        m.hg(repo, "init");
        repo.child("file").write("initial content", "UTF-8");
        m.hg(repo, "commit", "--addremove", "--message=initial");
        m.hg(repo, "tag", "version-1.0");
        m.hg(repo, "branch", "my-branch");
        repo.child("file2").write("content in branch", "UTF-8");
        m.hg(repo, "commit", "--addremove", "--message=branch");
        m.hg(repo, "tag", "version-1.1");
        installation.forNode((Node)MercurialSCMSourceTest.j.jenkins, (TaskListener)StreamTaskListener.fromStdout());
        mercurialSCMSource = new MercurialSCMSource(null, instName, tmp.toURI().toURL().toString(), null, null, null, null, null, true);
    }

    @Test
    void testRetrieveUnknownRevision() throws Exception {
        Assertions.assertNull((Object)mercurialSCMSource.fetch("does_not_exist", (TaskListener)listener, null));
    }

    @Test
    void testRetrieveTag() throws Exception {
        SCMRevision revision = mercurialSCMSource.fetch("version-1.1", (TaskListener)listener, null);
        Assertions.assertTrue((boolean)revision.toString().startsWith("my-branch:"));
        revision = mercurialSCMSource.fetch("version-1.0", (TaskListener)listener, null);
        Assertions.assertTrue((boolean)revision.toString().startsWith("default:"));
    }

    @Test
    void testRetrieveBranchTip() throws Exception {
        SCMRevision revision = mercurialSCMSource.fetch("my-branch", (TaskListener)listener, null);
        Assertions.assertTrue((boolean)revision.toString().startsWith("my-branch:"));
    }

    @Test
    void testRetrieveRepoTip() throws Exception {
        SCMRevision revision = mercurialSCMSource.fetch("tip", (TaskListener)listener, null);
        Assertions.assertTrue((boolean)revision.toString().startsWith("my-branch:"));
    }
}

