/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Describable;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolLocationNodeProperty;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jvnet.hudson.test.JenkinsRule;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class MercurialContainer
extends GenericContainer<MercurialContainer> {
    private File privateKey;

    public MercurialContainer() {
        super((Future)new ImageFromDockerfile("mercurial", false).withFileFromClasspath("Dockerfile", "hudson/plugins/mercurial/MercurialContainer/Dockerfile"));
        this.setExposedPorts(List.of(Integer.valueOf(22)));
    }

    public File getPrivateKey() {
        if (this.privateKey == null) {
            try {
                this.privateKey = File.createTempFile("ssh", "key");
                this.privateKey.deleteOnExit();
                FileUtils.copyURLToFile((URL)MercurialContainer.class.getResource("unsafe"), (File)this.privateKey);
                if (SystemUtils.IS_OS_UNIX) {
                    Files.setPosixFilePermissions(this.privateKey.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Not able to get the plaintext SSH key file. Missing file, wrong file permissions?!");
            }
        }
        return this.privateKey;
    }

    public Slave createAgent(JenkinsRule r) throws Exception {
        int num = r.jenkins.getNodes().size();
        String credentialsId = "test" + num;
        SystemCredentialsProvider.getInstance().setDomainCredentialsMap(Collections.singletonMap(Domain.global(), Collections.singletonList(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, credentialsId, null, "test", "test"))));
        DumbSlave agent = new DumbSlave("agent" + num, "/home/test/agent", (ComputerLauncher)new SSHLauncher(this.getHost(), this.getMappedPort(22).intValue(), credentialsId));
        agent.setNumExecutors(1);
        agent.setLabelString("mercurial");
        r.jenkins.addNode((Node)agent);
        r.waitOnline((Slave)agent);
        return agent;
    }

    public MercurialInstallation createInstallation(JenkinsRule r, Version v, boolean debug, boolean useCaches, boolean useSharing, String config, Slave ... agents) throws IOException {
        MercurialInstallation.DescriptorImpl desc = (MercurialInstallation.DescriptorImpl)r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class);
        ToolLocationNodeProperty.ToolLocation location = new ToolLocationNodeProperty.ToolLocation((ToolDescriptor)desc, v.name(), "/opt/mercurial-" + v.exactVersion);
        MercurialInstallation inst = new MercurialInstallation(v.name(), "", "INSTALLATION/hg", debug, useCaches, useSharing, config, null);
        desc.setInstallations((MercurialInstallation[])ArrayUtils.add((Object[])desc.getInstallations(), (Object)inst));
        for (Slave agent : agents) {
            List<ToolLocationNodeProperty.ToolLocation> locations;
            DescribableList props = agent.getNodeProperties();
            ToolLocationNodeProperty prop = (ToolLocationNodeProperty)props.get(ToolLocationNodeProperty.class);
            if (prop == null) {
                locations = Collections.singletonList(location);
            } else {
                locations = new ArrayList<ToolLocationNodeProperty.ToolLocation>(prop.getLocations());
                locations.add(location);
            }
            props.replace((Describable)new ToolLocationNodeProperty(locations));
        }
        return inst;
    }

    public static enum Version {
        HG6("6.6.3");

        public final String exactVersion;

        private Version(String exactVersion) {
            this.exactVersion = exactVersion;
        }
    }
}

