/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.User;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialChangeSetList;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.TreeSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.WithoutJenkins;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class MercurialChangeLogParserTest {
    private JenkinsRule j;
    @TempDir
    private File tmp;

    MercurialChangeLogParserTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.j = rule;
    }

    @Test
    void parseAddressFromChangeLog() throws Exception {
        File changelogXml = MercurialChangeLogParserTest.newFile(this.tmp, "changelog.xml");
        try (PrintWriter pw = new PrintWriter(changelogXml, StandardCharsets.UTF_8);){
            pw.println("<?xml version='1.0' encoding='UTF-8'?>");
            pw.println("<changesets>");
            pw.println("<changeset author='joe.schmo &lt;joe.schmo@example.com&gt;'/>");
            pw.println("</changesets>");
            pw.flush();
        }
        MercurialChangeLogParser clp = new MercurialChangeLogParser(null);
        ChangeLogSet cls = clp.parse(null, null, changelogXml);
        Iterator it = cls.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        User author = entry.getAuthor();
        Assertions.assertEquals((Object)"joe.schmo _joe.schmo@example.com_", (Object)author.getId());
        Assertions.assertEquals((Object)"joe.schmo <joe.schmo@example.com>", (Object)author.getFullName());
    }

    @WithoutJenkins
    @Test
    void oldAndNewFileFormats() throws Exception {
        File changelogXml = MercurialChangeLogParserTest.newFile(this.tmp, "changelog.xml");
        try (PrintWriter pw = new PrintWriter(changelogXml, StandardCharsets.UTF_8);){
            pw.println("<?xml version='1.0' encoding='UTF-8'?>");
            pw.println("<changesets>");
            pw.println("  <changeset>");
            pw.println("    <added>two</added>");
            pw.println("    <deleted></deleted>");
            pw.println("    <files>one two three</files>");
            pw.println("  </changeset>");
            pw.println("</changesets>");
        }
        Assertions.assertEquals((Object)"added=[two] deleted=[] modified=[one, three] ", (Object)MercurialChangeLogParserTest.summary(new MercurialChangeLogParser(null).parse(null, null, changelogXml)));
        pw = new PrintWriter(changelogXml, StandardCharsets.UTF_8);
        try {
            pw.println("<?xml version='1.0' encoding='UTF-8'?>");
            pw.println("<changesets>");
            pw.println("  <changeset>");
            pw.println("    <added>one</added>");
            pw.println("    <deleted>two</deleted>");
            pw.println("    <files>three</files>");
            pw.println("    <parents>6021:df659eb23360 6027:b7f44f01a632 </parents>");
            pw.println("  </changeset>");
            pw.println("</changesets>");
        }
        finally {
            pw.close();
        }
        Assertions.assertEquals((Object)"added=[] deleted=[] modified=[] ", (Object)MercurialChangeLogParserTest.summary(new MercurialChangeLogParser(null).parse(null, null, changelogXml)));
        pw = new PrintWriter(changelogXml, StandardCharsets.UTF_8);
        try {
            pw.println("<?xml version='1.0' encoding='UTF-8'?>");
            pw.println("<changesets>");
            pw.println("  <changeset>");
            pw.println("    <addedFile>two</addedFile>");
            pw.println("    <file>one</file>");
            pw.println("    <file>two</file>");
            pw.println("    <file>three</file>");
            pw.println("  </changeset>");
            pw.println("</changesets>");
        }
        finally {
            pw.close();
        }
        Assertions.assertEquals((Object)"added=[two] deleted=[] modified=[one, three] ", (Object)MercurialChangeLogParserTest.summary(new MercurialChangeLogParser(null).parse(null, null, changelogXml)));
        pw = new PrintWriter(changelogXml, StandardCharsets.UTF_8);
        try {
            pw.println("<?xml version='1.0' encoding='UTF-8'?>");
            pw.println("<changesets>");
            pw.println("  <changeset>");
            pw.println("    <deletedFile>one</deletedFile>");
            pw.println("    <file>one</file>");
            pw.println("    <file>two</file>");
            pw.println("    <file>three</file>");
            pw.println("  </changeset>");
            pw.println("</changesets>");
        }
        finally {
            pw.close();
        }
        Assertions.assertEquals((Object)"added=[] deleted=[one] modified=[three, two] ", (Object)MercurialChangeLogParserTest.summary(new MercurialChangeLogParser(null).parse(null, null, changelogXml)));
    }

    static String summary(MercurialChangeSetList csl) {
        StringBuilder b = new StringBuilder();
        for (MercurialChangeSet mcs : csl) {
            b.append("added=").append(new TreeSet(mcs.getAddedPaths())).append(" deleted=").append(new TreeSet(mcs.getDeletedPaths())).append(" modified=").append(new TreeSet(mcs.getModifiedPaths())).append(" ");
        }
        return b.toString();
    }

    private static File newFile(File parent, String child) throws IOException {
        File result = new File(parent, child);
        result.createNewFile();
        return result;
    }
}

