/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class HgExeFunctionalTest {
    private JenkinsRule j;
    private static final String INSTALLATION = "test";
    private MercurialInstallation mercurialInstallation;
    private TaskListener listener;
    private Launcher launcher;
    private EnvVars vars;

    HgExeFunctionalTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.j = rule;
        this.mercurialInstallation = new MercurialInstallation(INSTALLATION, "", "hg", false, true, false, Collections.emptyList());
        this.listener = new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset());
        this.launcher = this.j.jenkins.createLauncher(this.listener);
        this.vars = new EnvVars();
    }

    @Test
    void credentialsUsernamePasswordTest() throws Exception {
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "", "", "testuser", "testpassword");
        try (HgExe hgexe = new HgExe(this.mercurialInstallation, (StandardUsernameCredentials)credentials, this.launcher, (Node)this.j.jenkins, this.listener, this.vars);){
            ArgumentListBuilder b = hgexe.seed(false);
            Assertions.assertEquals((Object)new ArgumentListBuilder(new String[]{"hg", "--config", "auth.jenkins.prefix=*", "--config", "auth.jenkins.username=testuser", "--config", "auth.jenkins.password=testpassword", "--config", "auth.jenkins.schemes=http https"}).toList(), (Object)b.toList());
            Assertions.assertEquals((Object)new ArgumentListBuilder(new String[]{"hg", "--config", "auth.jenkins.prefix=*", "--config", "******", "--config", "******", "--config", "auth.jenkins.schemes=http https"}).toString(), (Object)b.toString());
        }
    }

    @Test
    void credentialsSSHKeyTest() throws Exception {
        BasicSSHUserPrivateKey.DirectEntryPrivateKeySource source = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource("test key\n");
        BasicSSHUserPrivateKey credentials = new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, "", "testuser", (BasicSSHUserPrivateKey.PrivateKeySource)source, null, null);
        try (HgExe hgexe = new HgExe(this.mercurialInstallation, (StandardUsernameCredentials)credentials, this.launcher, (Node)this.j.jenkins, this.listener, this.vars);){
            ArgumentListBuilder b = hgexe.seed(false);
            Matcher matcher = Pattern.compile("ssh\\s-i\\s(.+)\\s-l\\stestuser").matcher(b.toCommandArray()[2]);
            matcher.find();
            String fileName = matcher.group(1);
            Assertions.assertEquals((Object)"test key\n", (Object)FileUtils.readFileToString((File)new File(fileName), (Charset)StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)new ArgumentListBuilder(new String[]{"hg", "--config", "******"}).toString(), (Object)b.toString());
        }
    }

    @Test
    void customConfiguration() throws Exception {
        MercurialInstallation customConfiguration = new MercurialInstallation(INSTALLATION, "", "hg", false, false, false, "[defaults]\nclone = --uncompressed\n", null);
        try (HgExe hgexe = new HgExe(customConfiguration, null, this.launcher, (Node)this.j.jenkins, this.listener, this.vars);){
            ArgumentListBuilder b = hgexe.seed(false).add(new String[]{"clone", "http://some.thing/"});
            Assertions.assertEquals((Object)"hg --config defaults.clone=--uncompressed clone http://some.thing/", (Object)b.toString());
        }
    }
}

