/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.AbstractBuild;
import hudson.model.FreeStyleProject;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTestUtil;
import hudson.scm.SCM;
import java.io.File;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class DisableChangeLogTest {
    private JenkinsRule j;
    private MercurialTestUtil m;
    @TempDir
    private File tmp;
    private File repo;
    private static final String DISABLE_CHANGELOG_INSTALLATION = "changelog";

    DisableChangeLogTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.j = rule;
        this.m = new MercurialTestUtil(this.j);
        this.repo = this.tmp;
        ((MercurialInstallation.DescriptorImpl)this.j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(DISABLE_CHANGELOG_INSTALLATION, "", "hg", true, false, false, Collections.emptyList())});
    }

    protected String hgInstallation() {
        return DISABLE_CHANGELOG_INSTALLATION;
    }

    @Test
    void changelogIsDisabled() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.BRANCH, null, null, null, null, false, null, true));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertTrue((boolean)b.getChangeSet().isEmptySet());
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assertions.assertTrue((boolean)b.getChangeSet().isEmptySet());
    }
}

