package hudson.plugins.mercurial.browser;

import hudson.Extension;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.util.FormValidation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;


import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/**
 * Mercurial web interface served using FishEye.
 */
public class FishEye extends HgBrowser {
    
    @DataBoundConstructor
    public FishEye(String url) throws MalformedURLException {
        super(url);
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public URL getChangeSetLink(MercurialChangeSet changeSet)
            throws IOException {
        current = changeSet;

        // replace /browse/ with /changelog/ so that the full changeset changelog will be displayed 
        String url = getUrl().toExternalForm();
        url = url.replaceAll("/browse/", "/changelog/");
        if (url.endsWith("/"))
        {
            url = url.substring(0, url.length() - 1);
        }
        // http://www.example.org/changelog/hg?cs=0a43e7e89449d1ca8a9da37e1cc644a620d48e71
        return new URL(url + "?cs=" + changeSet.getNode());
    }

    /**
     * {@inheritDoc} 
     * 
     * Throws {@link IllegalStateException} when this method is called before at least one call 
     * to {@literal getChangeSetLink(MercurialChangeSet)}.
     */
    @Override
    public URL getFileLink(String path) throws MalformedURLException {
        checkCurrentIsNotNull();
        // http://www.example.org/browse/hg/samplefile.txt#0a43e7e89449d1ca8a9da37e1cc644a620d48e71
        return new URL(getUrl(), path + "#" + current.getNode());
    }
    
    /**
     * {@inheritDoc}
     * 
     * Throws {@link IllegalStateException} when this method is called before at least one call 
     * to {@literal getChangeSetLink(MercurialChangeSet)}.
     */
    @Override
    public URL getDiffLink(String path) throws MalformedURLException {
        checkCurrentIsNotNull();
            
        // http://www.example.org/browse/hg/samplefile.txt?r1=0a43e7e89449d1ca8a9da37e1cc644a620d48e71&r2=
        return new URL(getUrl(), path + "?r1=" + current.getNode() + "&r2=");
    }
    
    @Extension
    public static class DescriptorImpl extends HgBrowserDescriptor {
        public String getDisplayName() {
            return "fisheye";
        }

        @Override public FormValidation doCheckUrl(@QueryParameter String url) {
            return _doCheckUrl(url);
        }

    }

    private static final long serialVersionUID = 1L;
}
