// CHECKSTYLE:OFF

package hudson.plugins.mercurial;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code MercurialSCM.failed_to_clone}: {@code Failed to clone {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to clone {0}}
     */
    public static String MercurialSCM_failed_to_clone(Object arg0) {
        return holder.format("MercurialSCM.failed_to_clone", arg0);
    }

    /**
     * Key {@code MercurialSCM.failed_to_clone}: {@code Failed to clone {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to clone {0}}
     */
    public static Localizable _MercurialSCM_failed_to_clone(Object arg0) {
        return new Localizable(holder, "MercurialSCM.failed_to_clone", arg0);
    }

    /**
     * Key {@code HgExe.expected_to_get_hg_version_name_but_got_nothing}:
     * {@code Expected to get a mercurial version but got an empty string
     * instead.}.
     * 
     * @return
     *     {@code Expected to get a mercurial version but got an empty string
     *     instead.}
     */
    public static String HgExe_expected_to_get_hg_version_name_but_got_nothing() {
        return holder.format("HgExe.expected_to_get_hg_version_name_but_got_nothing");
    }

    /**
     * Key {@code HgExe.expected_to_get_hg_version_name_but_got_nothing}:
     * {@code Expected to get a mercurial version but got an empty string
     * instead.}.
     * 
     * @return
     *     {@code Expected to get a mercurial version but got an empty string
     *     instead.}
     */
    public static Localizable _HgExe_expected_to_get_hg_version_name_but_got_nothing() {
        return new Localizable(holder, "HgExe.expected_to_get_hg_version_name_but_got_nothing");
    }

    /**
     * Key {@code MercurialSCM.failed_to_compare_with_remote_repository}:
     * {@code Failed to compare with remote repository because hg could not
     * be found; check that you''ve properly configured your Mercurial
     * installation}.
     * 
     * @return
     *     {@code Failed to compare with remote repository because hg could not
     *     be found; check that you''ve properly configured your Mercurial
     *     installation}
     */
    public static String MercurialSCM_failed_to_compare_with_remote_repository() {
        return holder.format("MercurialSCM.failed_to_compare_with_remote_repository");
    }

    /**
     * Key {@code MercurialSCM.failed_to_compare_with_remote_repository}:
     * {@code Failed to compare with remote repository because hg could not
     * be found; check that you''ve properly configured your Mercurial
     * installation}.
     * 
     * @return
     *     {@code Failed to compare with remote repository because hg could not
     *     be found; check that you''ve properly configured your Mercurial
     *     installation}
     */
    public static Localizable _MercurialSCM_failed_to_compare_with_remote_repository() {
        return new Localizable(holder, "MercurialSCM.failed_to_compare_with_remote_repository");
    }

    /**
     * Key {@code MercurialRevisionColumn.DisplayName}: {@code Mercurial
     * Branch}.
     * 
     * @return
     *     {@code Mercurial Branch}
     */
    public static String MercurialRevisionColumn_DisplayName() {
        return holder.format("MercurialRevisionColumn.DisplayName");
    }

    /**
     * Key {@code MercurialRevisionColumn.DisplayName}: {@code Mercurial
     * Branch}.
     * 
     * @return
     *     {@code Mercurial Branch}
     */
    public static Localizable _MercurialRevisionColumn_DisplayName() {
        return new Localizable(holder, "MercurialRevisionColumn.DisplayName");
    }

    /**
     * Key {@code HgExe.expected_to_get_a_branch_name_but_got_nothing}:
     * {@code Expected to get a branch name but got an empty name instead.}.
     * 
     * @return
     *     {@code Expected to get a branch name but got an empty name instead.}
     */
    public static String HgExe_expected_to_get_a_branch_name_but_got_nothing() {
        return holder.format("HgExe.expected_to_get_a_branch_name_but_got_nothing");
    }

    /**
     * Key {@code HgExe.expected_to_get_a_branch_name_but_got_nothing}:
     * {@code Expected to get a branch name but got an empty name instead.}.
     * 
     * @return
     *     {@code Expected to get a branch name but got an empty name instead.}
     */
    public static Localizable _HgExe_expected_to_get_a_branch_name_but_got_nothing() {
        return new Localizable(holder, "HgExe.expected_to_get_a_branch_name_but_got_nothing");
    }

    /**
     * Key {@code HgExe.cannot_extract_hg_version}: {@code Cannot extract hg
     * version}.
     * 
     * @return
     *     {@code Cannot extract hg version}
     */
    public static String HgExe_cannot_extract_hg_version() {
        return holder.format("HgExe.cannot_extract_hg_version");
    }

    /**
     * Key {@code HgExe.cannot_extract_hg_version}: {@code Cannot extract hg
     * version}.
     * 
     * @return
     *     {@code Cannot extract hg version}
     */
    public static Localizable _HgExe_cannot_extract_hg_version() {
        return new Localizable(holder, "HgExe.cannot_extract_hg_version");
    }

    /**
     * Key {@code MercurialInstallation.mercurial}: {@code Mercurial}.
     * 
     * @return
     *     {@code Mercurial}
     */
    public static String MercurialInstallation_mercurial() {
        return holder.format("MercurialInstallation.mercurial");
    }

    /**
     * Key {@code MercurialInstallation.mercurial}: {@code Mercurial}.
     * 
     * @return
     *     {@code Mercurial}
     */
    public static Localizable _MercurialInstallation_mercurial() {
        return new Localizable(holder, "MercurialInstallation.mercurial");
    }

    /**
     * Key {@code MercurialSCM.non_dependent_changes_detected}: {@code
     * Non-dependent changes detected}.
     * 
     * @return
     *     {@code Non-dependent changes detected}
     */
    public static String MercurialSCM_non_dependent_changes_detected() {
        return holder.format("MercurialSCM.non_dependent_changes_detected");
    }

    /**
     * Key {@code MercurialSCM.non_dependent_changes_detected}: {@code
     * Non-dependent changes detected}.
     * 
     * @return
     *     {@code Non-dependent changes detected}
     */
    public static Localizable _MercurialSCM_non_dependent_changes_detected() {
        return new Localizable(holder, "MercurialSCM.non_dependent_changes_detected");
    }

    /**
     * Key {@code MercurialStatus.mercurial}: {@code Mercurial}.
     * 
     * @return
     *     {@code Mercurial}
     */
    public static String MercurialStatus_mercurial() {
        return holder.format("MercurialStatus.mercurial");
    }

    /**
     * Key {@code MercurialStatus.mercurial}: {@code Mercurial}.
     * 
     * @return
     *     {@code Mercurial}
     */
    public static Localizable _MercurialStatus_mercurial() {
        return new Localizable(holder, "MercurialStatus.mercurial");
    }

    /**
     * Key {@code MercurialTagAction.BuildData}: {@code Mercurial Build
     * Data}.
     * 
     * @return
     *     {@code Mercurial Build Data}
     */
    public static String MercurialTagAction_BuildData() {
        return holder.format("MercurialTagAction.BuildData");
    }

    /**
     * Key {@code MercurialTagAction.BuildData}: {@code Mercurial Build
     * Data}.
     * 
     * @return
     *     {@code Mercurial Build Data}
     */
    public static Localizable _MercurialTagAction_BuildData() {
        return new Localizable(holder, "MercurialTagAction.BuildData");
    }

    /**
     * Key {@code MercurialSCM.dependent_changes_detected}: {@code Dependent
     * changes detected}.
     * 
     * @return
     *     {@code Dependent changes detected}
     */
    public static String MercurialSCM_dependent_changes_detected() {
        return holder.format("MercurialSCM.dependent_changes_detected");
    }

    /**
     * Key {@code MercurialSCM.dependent_changes_detected}: {@code Dependent
     * changes detected}.
     * 
     * @return
     *     {@code Dependent changes detected}
     */
    public static Localizable _MercurialSCM_dependent_changes_detected() {
        return new Localizable(holder, "MercurialSCM.dependent_changes_detected");
    }

    /**
     * Key {@code HgExe.expected_to_get_a_revision_number_but_got_instead}:
     * {@code Expected to get a revision number but got ''{0}'' instead.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected to get a revision number but got ''{0}'' instead.}
     */
    public static String HgExe_expected_to_get_a_revision_number_but_got_instead(Object arg0) {
        return holder.format("HgExe.expected_to_get_a_revision_number_but_got_instead", arg0);
    }

    /**
     * Key {@code HgExe.expected_to_get_a_revision_number_but_got_instead}:
     * {@code Expected to get a revision number but got ''{0}'' instead.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Expected to get a revision number but got ''{0}'' instead.}
     */
    public static Localizable _HgExe_expected_to_get_a_revision_number_but_got_instead(Object arg0) {
        return new Localizable(holder, "HgExe.expected_to_get_a_revision_number_but_got_instead", arg0);
    }

}
