package hudson.plugins.mercurial;

import hudson.scm.ChangeLogSet;
import hudson.model.Run;
import hudson.scm.RepositoryBrowser;

import java.util.List;
import java.util.Collections;
import java.util.Iterator;

/**
 * List of changeset that went into a particular build.
 */
public class MercurialChangeSetList extends ChangeLogSet<MercurialChangeSet> {
    private final List<MercurialChangeSet> changeSets;

    /*package*/ MercurialChangeSetList(Run<?,?> build, RepositoryBrowser<?> browser, List<MercurialChangeSet> logs) {
        super(build, browser);
        Collections.reverse(logs);  // put new things first
        this.changeSets = Collections.unmodifiableList(logs);
        for (MercurialChangeSet log : logs)
            log.setParent(this);
    }

    public boolean isEmptySet() {
        return changeSets.isEmpty();
    }

    public Iterator<MercurialChangeSet> iterator() {
        return changeSets.iterator();
    }

    public List<MercurialChangeSet> getLogs() {
        return changeSets;
    }

    public @Override String getKind() {
        return "hg";
    }

}
