/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.plugins.mercurial.browser.AbstractBrowserTestBase;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.RhodeCode;
import java.io.IOException;
import java.net.MalformedURLException;
import org.junit.Assert;
import org.junit.Test;

public class RhodeCodeTest
extends AbstractBrowserTestBase {
    private static final String REPO_URL = "https://secure.rhodecode.org/rhodecode";

    public RhodeCodeTest() throws MalformedURLException {
        super((HgBrowser)new RhodeCode(REPO_URL));
    }

    @Override
    @Test(expected=IllegalStateException.class)
    public void testGetFileLinkIllegalState() throws IOException {
        this.browser.getFileLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java");
    }

    @Override
    @Test(expected=IllegalStateException.class)
    public void testGetDiffLinkIllegalState() throws IOException {
        this.browser.getDiffLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java");
    }

    @Test
    public void testGetFileLink() throws IOException {
        String expected = "https://secure.rhodecode.org/rhodecode/files/6704efde87541766fadba17f66d04b926cd4d343/rhodecode/public/css/pygments.css";
        this.browser.getChangeSetLink(this.changeSet);
        Assert.assertEquals((Object)expected, (Object)this.browser.getFileLink("rhodecode/public/css/pygments.css").toExternalForm());
    }

    @Test
    public void testGetDiffLink() throws IOException {
        String expected = "https://secure.rhodecode.org/rhodecode/changeset/6704efde87541766fadba17f66d04b926cd4d343#Crhodecode-public-css-pygments.css";
        this.browser.getChangeSetLink(this.changeSet);
        Assert.assertEquals((Object)expected, (Object)this.browser.getDiffLink("rhodecode/public/css/pygments.css").toExternalForm());
    }

    @Test
    public void testGetChangeSetLinkMercurialChangeSet() throws IOException {
        String expected = "https://secure.rhodecode.org/rhodecode/changeset/6704efde87541766fadba17f66d04b926cd4d343";
        Assert.assertEquals((Object)expected, (Object)this.browser.getChangeSetLink(this.changeSet).toExternalForm());
    }
}

