/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractBrowserTestBase {
    protected final HgBrowser browser;
    protected final MercurialChangeSet changeSet;

    public AbstractBrowserTestBase(HgBrowser browser) {
        this.browser = browser;
        this.changeSet = new MercurialChangeSet();
        this.changeSet.setNode("6704efde87541766fadba17f66d04b926cd4d343");
    }

    @Test(expected=IllegalStateException.class)
    public void testGetFileLinkIllegalState() throws IOException {
        this.browser.getFileLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java");
    }

    @Test(expected=IllegalStateException.class)
    public void testGetDiffLinkIllegalState() throws IOException {
        this.browser.getDiffLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java");
    }

    protected void testGetFileLink(String expected) throws IOException {
        this.browser.getChangeSetLink(this.changeSet);
        Assert.assertEquals((Object)expected, (Object)this.browser.getFileLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java").toExternalForm());
    }

    protected void testGetDiffLink(String expected) throws IOException {
        this.browser.getChangeSetLink(this.changeSet);
        Assert.assertEquals((Object)expected, (Object)this.browser.getDiffLink("src/main/java/hudson/plugins/mercurial/browser/HgBrowser.java").toExternalForm());
    }

    protected void testGetChangeSetLinkMercurialChangeSet(String expected) throws IOException {
        Assert.assertEquals((Object)expected, (Object)this.browser.getChangeSetLink(this.changeSet).toExternalForm());
    }
}

