/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.slaves.DumbSlave;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.JenkinsRule;

public abstract class SCMTestBase {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    private File repo;

    @BeforeClass
    public static void requiresLocalHg() throws Exception {
        try {
            if (new ProcessBuilder("hg", "--version").start().waitFor() != 0) {
                throw new AssumptionViolatedException("hg --version signaled an error");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (message.startsWith("Cannot run program \"hg\"") && message.endsWith("No such file or directory")) {
                throw new AssumptionViolatedException("hg is not available; please check that your PATH environment variable is properly configured");
            }
            Assume.assumeNoException((Throwable)ioe);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.repo = this.tmp.getRoot();
    }

    @CheckForNull
    protected abstract String hgInstallation() throws Exception;

    protected void assertClone(String log, boolean cloneExpected) {
        if (cloneExpected) {
            Assert.assertTrue((String)log, (boolean)log.contains(" clone --"));
        } else {
            Assert.assertTrue((String)log, (boolean)log.contains(" update --"));
            Assert.assertFalse((String)log, (boolean)log.contains(" clone --"));
        }
    }

    @Test
    public void pollingLimitedToModules() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1 dir2", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f");
        this.m.buildAndCheck(p, "dir1/f", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir2/f");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir2/f", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir3/f");
        pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir3/f", new Action[0]);
    }

    @Test
    public void pollingLimitedToModules2() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir2/f");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
        this.m.touchAndCommit(this.repo, "dir1/f");
        pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir1/f", new Action[0]);
    }

    @Test
    public void pollingLimitedToModules3() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1/f", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.touchAndCommit(this.repo, "dir1/g");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
        this.m.touchAndCommit(this.repo, "dir1/f");
        pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "dir1/f", new Action[0]);
    }

    @Test
    public void pollingIgnoresMetaFiles() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f");
        this.m.buildAndCheck(p, "f", new Action[0]);
        this.m.hg(this.repo, "tag", "mystuff");
        Assert.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)this.m.pollSCMChanges((FreeStyleProject)p).change);
    }

    @Test
    public void pollingHonorsBranchMerges() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "feature");
        this.m.hg(this.repo, "update", "default");
        this.m.hg(this.repo, "merge", "b");
        this.m.hg(this.repo, "commit", "--message", "merged");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "feature", new Action[0]);
    }

    @Test
    public void pollingHonorsBranchMergesWithModules() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "mod1", null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "starter");
        this.m.pollSCMChanges(p);
        this.m.buildAndCheck(p, "starter", new Action[0]);
        this.m.hg(this.repo, "branch", "mod1dev");
        this.m.touchAndCommit(this.repo, "mod1/feature");
        this.m.hg(this.repo, "update", "default");
        this.m.hg(this.repo, "merge", "mod1dev");
        this.m.hg(this.repo, "commit", "--message", "merged");
        PollingResult pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)pr.change);
        this.m.buildAndCheck(p, "mod1/feature", new Action[0]);
        this.m.hg(this.repo, "branch", "mod2dev");
        this.m.touchAndCommit(this.repo, "mod2/feature");
        this.m.hg(this.repo, "update", "default");
        this.m.hg(this.repo, "merge", "mod2dev");
        this.m.hg(this.repo, "commit", "--message", "merged");
        pr = this.m.pollSCMChanges(p);
        Assert.assertEquals((Object)PollingResult.Change.INSIGNIFICANT, (Object)pr.change);
    }

    @Test
    public void changelogLimitedToModules() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        p.scheduleBuild2(0).get();
        this.m.touchAndCommit(this.repo, "dir2/f1");
        Iterator it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assert.assertEquals(Collections.singleton("dir2/f1"), new HashSet(entry.getAffectedPaths()));
        Assert.assertFalse((boolean)it.hasNext());
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "dir1 extra", null, null, false));
        this.m.touchAndCommit(this.repo, "dir1/f2");
        this.m.touchAndCommit(this.repo, "dir2/f2");
        it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assert.assertEquals(Collections.singleton("dir1/f2"), new HashSet(entry.getAffectedPaths()));
        Assert.assertFalse((boolean)it.hasNext());
        this.m.touchAndCommit(this.repo, "dir2/f3", "dir1/f3");
        this.m.touchAndCommit(this.repo, "dir2/f4", "dir2/f5");
        it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("dir1/f3", "dir2/f3")), new HashSet(entry.getAffectedPaths()));
        Assert.assertFalse((boolean)it.hasNext());
        this.m.touchAndCommit(this.repo, "extra/f1");
        it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assert.assertEquals(Collections.singleton("extra/f1"), new HashSet(entry.getAffectedPaths()));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void parameterizedBuildsBranch() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "trunk");
        this.m.hg(this.repo, "update", "null");
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "variant");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "${BRANCH}", null, null, null, false));
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("BRANCH", "b")}));
        String log = this.m.buildAndCheck(p, "variant", new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("BRANCH", "b")})});
        Assert.assertTrue((String)log, (boolean)log.contains("--rev b"));
        Assert.assertFalse((String)log, (boolean)log.contains("--rev ${BRANCH}"));
        this.m.touchAndCommit(this.repo, "further-variant");
        this.m.buildAndCheck(p, "further-variant", new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("BRANCH", "b")})});
    }

    @Test
    public void pollingExpandsParameterDefaults() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "trunk");
        this.m.hg(this.repo, "update", "null");
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "variant");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("branch", "default")}));
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "${branch}", null, null, null, false));
        String log = this.m.buildAndCheck(p, "trunk", new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("branch", "default")})});
        Assert.assertTrue((String)log, (boolean)log.contains("--rev default"));
        Assert.assertEquals((Object)PollingResult.Change.NONE, (Object)this.m.pollSCMChanges((FreeStyleProject)p).change);
        this.m.hg(this.repo, "update", "default");
        this.m.touchAndCommit(this.repo, "trunk2");
        Assert.assertEquals((Object)PollingResult.Change.SIGNIFICANT, (Object)this.m.pollSCMChanges((FreeStyleProject)p).change);
    }

    @Test
    public void fileListOmittedForMerges() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        p.scheduleBuild2(0).get();
        this.m.hg(this.repo, "up", "null");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.hg(this.repo, "merge");
        this.m.hg(this.repo, "commit", "--message", "merge");
        Iterator it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assert.assertTrue((boolean)((MercurialChangeSet)entry).isMerge());
        Assert.assertEquals(Collections.emptySet(), new HashSet(entry.getAffectedPaths()));
        Assert.assertTrue((boolean)it.hasNext());
        entry = (ChangeLogSet.Entry)it.next();
        Assert.assertFalse((boolean)((MercurialChangeSet)entry).isMerge());
        Assert.assertEquals(Collections.singleton("f2"), new HashSet(entry.getAffectedPaths()));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void changesMergedToRenamedModulesTriggerBuild() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "alltogether/some_interface", "alltogether/some_class");
        this.m.hg(this.repo, "branch", "stable");
        this.m.touchAndCommit(this.repo, "alltogether/some_class");
        this.m.hg(this.repo, "up", "default");
        this.m.hg(this.repo, "mv", "alltogether/some_interface", "api/some_interface");
        this.m.hg(this.repo, "mv", "alltogether/some_class", "impl/some_class");
        this.m.hg(this.repo, "commit", "--message", "reorganizing repository to properly split api and implementation");
        String reorganizationCommit = this.m.getLastChangesetId(this.repo);
        FreeStyleProject projectForImplModule = this.j.createFreeStyleProject();
        projectForImplModule.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, "impl", null, null, false));
        projectForImplModule.scheduleBuild2(0).get();
        this.m.hg(this.repo, "merge", "stable");
        this.m.hg(this.repo, "commit", "--message", "merge changes from stable branch");
        String mergeCommit = this.m.getLastChangesetId(this.repo);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, reorganizationCommit, mergeCommit, this.m.pollSCMChanges(projectForImplModule));
    }

    @Test
    public void subdirectoryCheckout() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, "repo", null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.buildAndCheck(p, "repo/f1", new Action[0]);
        this.m.touchAndCommit(this.repo, "f2");
        this.m.buildAndCheck(p, "repo/f2", new Action[0]);
        this.m.touchAndCommit(this.repo, "f3");
        Iterator it = ((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)it.next();
        Assert.assertEquals(Collections.singleton("f3"), new HashSet(entry.getAffectedPaths()));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void clean() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, true));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.buildAndCheck(p, "f1", new Action[0]);
        FilePath ws = ((FreeStyleBuild)p.getLastBuild()).getWorkspace();
        ws.child("junk1").write("junk", null);
        ws.child("junk2").write("junk", null);
        this.m.hg(new File(ws.getRemote()), "add", "junk2");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.buildAndCheck(p, "f2", new Action[0]);
        TreeSet<String> kids = new TreeSet<String>();
        for (FilePath kid : ws.list()) {
            kids.add(kid.getName());
        }
        Assert.assertEquals((Object)"[.hg, f1, f2]", (Object)((Object)kids).toString());
    }

    @Test
    public void multipleProjectsForSingleSource() throws Exception {
        FreeStyleProject one = this.j.createFreeStyleProject();
        FreeStyleProject two = this.j.createFreeStyleProject();
        FreeStyleProject three = this.j.createFreeStyleProject();
        FreeStyleProject four = this.j.createFreeStyleProject();
        one.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        two.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        three.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "b", null, null, null, false));
        four.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "b", null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        Assert.assertTrue((boolean)this.m.pollSCMChanges(one).hasChanges());
        this.m.buildAndCheck(one, "f1", new Action[0]);
        Assert.assertTrue((boolean)this.m.pollSCMChanges(two).hasChanges());
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "b1");
        Assert.assertFalse((boolean)this.m.pollSCMChanges(one).hasChanges());
        this.m.buildAndCheck(three, "b1", new Action[0]);
        this.m.buildAndCheck(four, "b1", new Action[0]);
        this.m.touchAndCommit(this.repo, "b2");
        Assert.assertTrue((boolean)this.m.pollSCMChanges(three).hasChanges());
        this.m.buildAndCheck(three, "b2", new Action[0]);
        Assert.assertTrue((boolean)this.m.pollSCMChanges(four).hasChanges());
        Assert.assertFalse((boolean)this.m.pollSCMChanges(one).hasChanges());
    }

    @Test
    public void changelogOnUpdate() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertTrue((boolean)b.getChangeSet().isEmptySet());
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir2/f1")), b);
        this.m.touchAndCommit(this.repo, "dir3/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir3/f1")), b);
    }

    @Test
    public void changelogOnClone() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertTrue((boolean)b.getChangeSet().isEmptySet());
        b.getWorkspace().deleteRecursive();
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir2/f1")), b);
        b.getWorkspace().deleteRecursive();
        this.m.touchAndCommit(this.repo, "dir3/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir3/f1")), b);
    }

    @Test
    public void changelogFromPreviousBuild() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        DumbSlave s1 = this.j.createOnlineSlave();
        DumbSlave s2 = this.j.createOnlineSlave();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        p.setAssignedNode((Node)s1);
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertTrue((boolean)b.getChangeSet().isEmptySet());
        p.setAssignedNode((Node)s2);
        this.m.touchAndCommit(this.repo, "dir2/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        p.setAssignedNode((Node)s1);
        this.m.touchAndCommit(this.repo, "dir3/f1");
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.assertChangeSetPaths(Collections.singletonList(Collections.singleton("dir3/f1")), b);
    }

    @Test
    public void polling() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        p.setAssignedLabel(null);
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        String cs1 = this.m.getLastChangesetId(this.repo);
        PollingResult pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.INCOMPARABLE, null, null, pr);
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.NONE, cs1, cs1, pr);
        this.m.touchAndCommit(this.repo, "f2");
        String cs2 = this.m.getLastChangesetId(this.repo);
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, cs1, cs2, pr);
        b.getWorkspace().deleteRecursive();
        pr = this.m.pollSCMChanges(p);
        if (p.getScm().requiresWorkspaceForPolling()) {
            this.assertPollingResult(PollingResult.Change.INCOMPARABLE, null, null, pr);
        } else {
            this.assertPollingResult(PollingResult.Change.NONE, cs2, cs2, pr);
        }
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        this.m.touchAndCommit(this.repo, "f3");
        this.m.touchAndCommit(this.repo, "f4");
        String cs4 = this.m.getLastChangesetId(this.repo);
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, cs2, cs4, pr);
        this.m.touchAndCommit(this.repo, "f5");
        String cs5 = this.m.getLastChangesetId(this.repo);
        pr = this.m.pollSCMChanges(p);
        this.assertPollingResult(PollingResult.Change.SIGNIFICANT, cs4, cs5, pr);
    }

    @Test
    public void trailingUrlWhitespace() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath() + " ", null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)b.getResult());
    }

    @Test
    public void nonExistingBranchesDontGenerateMercurialTagActionsInTheBuild() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), "non-existing-branch", null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "dir1/f1");
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        for (Action action : b.getActions()) {
            if (!(action instanceof MercurialTagAction)) continue;
            Assert.fail((String)"There should not be any MercurialTagAction");
        }
    }

    @Test
    public void tags() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.hg(this.repo, "tag", "release");
        this.m.touchAndCommit(this.repo, "f3");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.TAG, "release", null, null, null, false, null));
        FreeStyleBuild b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assert.assertTrue((boolean)ws.child("f1").exists());
        Assert.assertTrue((boolean)ws.child("f2").exists());
        Assert.assertFalse((boolean)ws.child("f3").exists());
        this.m.hg(this.repo, "tag", "--force", "release");
        b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        Assert.assertTrue((String)JenkinsRule.getLog((Run)b), (boolean)ws.child("f3").exists());
    }

    @Test
    public void revsets() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        this.m.touchAndCommit(this.repo, "f2");
        this.m.hg(this.repo, "log");
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.REVSET, "first(parents(tip))", null, null, null, false, null));
        FreeStyleBuild b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assert.assertTrue((boolean)ws.child("f1").exists());
        Assert.assertFalse((boolean)ws.child("f2").exists());
        this.m.hg(this.repo, "update", "-r", "0");
        this.m.touchAndCommit(this.repo, "f3");
        this.m.hg(this.repo, "merge");
        this.m.hg(this.repo, "commit", "-m", "Merged some stuff");
        b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        ws = b.getWorkspace();
        Assert.assertTrue((boolean)ws.child("f1").exists());
        Assert.assertTrue((boolean)ws.child("f2").exists());
        Assert.assertFalse((boolean)ws.child("f3").exists());
        this.m.touchAndCommit(this.repo, "f4");
        b = (FreeStyleBuild)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        ws = b.getWorkspace();
        Assert.assertTrue((boolean)ws.child("f1").exists());
        Assert.assertTrue((boolean)ws.child("f2").exists());
        Assert.assertTrue((boolean)ws.child("f3").exists());
        Assert.assertFalse((boolean)ws.child("f4").exists());
    }

    private void assertChangeSetPaths(List<? extends Set<String>> expectedChangeSetPaths, AbstractBuild<?, ?> build) throws IOException {
        ChangeLogSet actualChangeLogSet = build.getChangeSet();
        LinkedList actualChangeSetPaths = new LinkedList();
        for (ChangeLogSet.Entry entry : actualChangeLogSet) {
            actualChangeSetPaths.add(new LinkedHashSet(entry.getAffectedPaths()));
        }
        Assert.assertEquals((String)build.getLog(99).toString(), expectedChangeSetPaths, actualChangeSetPaths);
    }

    private void assertPollingResult(PollingResult.Change expectedChangeDegree, String expectedBaselineId, String expectedRemoteId, PollingResult actualPollingResult) {
        Assert.assertNotNull((Object)actualPollingResult);
        PollingResult.Change actualChangeDegree = actualPollingResult.change;
        Assert.assertEquals((Object)expectedChangeDegree, (Object)actualChangeDegree);
        if (expectedBaselineId == null) {
            Assert.assertNull((Object)actualPollingResult.baseline);
        } else {
            MercurialTagAction actualBaseline = (MercurialTagAction)actualPollingResult.baseline;
            Assert.assertEquals((Object)expectedBaselineId, (Object)actualBaseline.id);
        }
        if (expectedRemoteId == null) {
            Assert.assertNull((Object)actualPollingResult.remote);
        } else {
            MercurialTagAction actualRemote = (MercurialTagAction)actualPollingResult.remote;
            Assert.assertEquals((Object)expectedRemoteId, (Object)actualRemote.id);
        }
    }

    @Test
    public void testPullReturnCode() throws Exception {
        File repoOnline = this.tmp.newFolder();
        File repoOffline = new File(repoOnline.getPath() + "-offline");
        this.m.hg(repoOnline, "init");
        this.m.touchAndCommit(repoOnline, "init");
        this.m.hg(repoOnline, "tag", "init");
        FreeStyleProject p = this.j.createFreeStyleProject();
        MercurialSCM a = new MercurialSCM(this.hgInstallation(), repoOnline.getPath(), null, null, null, null, false);
        p.setScm((SCM)a);
        AbstractBuild b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)b.getResult());
        repoOnline.renameTo(repoOffline);
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertNotEquals((Object)Result.SUCCESS, (Object)b.getResult());
        repoOffline.renameTo(repoOnline);
        b = (AbstractBuild)p.scheduleBuild2(0).get();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)b.getResult());
    }

    private void initRepoWithTag() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "init");
        this.m.hg(this.repo, "branch", "stable");
        this.m.touchAndCommit(this.repo, "stable commit");
        this.m.hg(this.repo, "tag", "release");
        this.m.hg(this.repo, "update", "--clean", "default");
    }

    @Test
    public void testGetBranchFromTag() throws Exception {
        this.initRepoWithTag();
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.TAG, "release", null, null, null, false, null));
        FreeStyleBuild b = this.j.buildAndAssertSuccess(p);
        MercurialTagAction action = (MercurialTagAction)b.getAction(MercurialTagAction.class);
        Assert.assertNotNull((Object)action);
        Assert.assertEquals((Object)"stable", (Object)action.getBranch());
        Assert.assertEquals((Object)"stable", (Object)b.getEnvironment().get((Object)"MERCURIAL_REVISION_BRANCH"));
    }

    @Test
    public void testGetNoBranchFromBranch() throws Exception {
        this.initRepoWithTag();
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), MercurialSCM.RevisionType.BRANCH, "default", null, null, null, false, null));
        FreeStyleBuild b = this.j.buildAndAssertSuccess(p);
        MercurialTagAction action = (MercurialTagAction)b.getAction(MercurialTagAction.class);
        Assert.assertNotNull((Object)action);
        Assert.assertEquals(null, (Object)action.getBranch());
        Assert.assertEquals(null, (Object)b.getEnvironment().get((Object)"MERCURIAL_REVISION_BRANCH"));
    }

    @Test
    public void testChangeSetApiVersion1407Methods() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.hgInstallation(), this.repo.getPath(), null, null, null, null, false));
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "f1");
        p.scheduleBuild2(0).get();
        this.m.touchAndCommit(this.repo, "f2");
        MercurialChangeSet changeSet = (MercurialChangeSet)((FreeStyleBuild)p.scheduleBuild2(0).get()).getChangeSet().iterator().next();
        String commitId = this.m.getLastChangesetId(this.repo);
        long timestampInSeconds = this.m.getLastChangesetUnixTimestamp(this.repo);
        Assert.assertEquals((Object)commitId, (Object)changeSet.getCommitId());
        Assert.assertEquals((long)(timestampInSeconds * 1000L), (long)changeSet.getTimestamp());
    }

    @Extension
    public static final class ShowChangelogs
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            System.out.println("---%<--- " + String.valueOf(changelogFile));
            FileUtils.copyFile((File)changelogFile, (OutputStream)System.out);
            System.out.println("\n--->%---");
        }
    }

    private static final class NoopFakeLauncher
    implements FakeLauncher {
        private NoopFakeLauncher() {
        }

        public Proc onLaunch(Launcher.ProcStarter p) throws IOException {
            return null;
        }
    }
}

