/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.plugins.mercurial.MercurialStatus;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class MercurialStatusTest {
    @Test
    public void testLooselyMatches() throws URISyntaxException {
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/"), (String)"ssh://somehost"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost"), (String)"http://somehost/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost:80/"), (String)"http://somehost/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost"), (String)"http://somehost:80/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost:443"), (String)"https://somehost/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/"), (String)"https://somehost:443/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost:443/"), (String)"https://somehost:443/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/jenkins"), (String)"http://somehost/jenkins"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost:80/jenkins"), (String)"http://somehost:80/jenkins"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins"), (String)"https://somehost/jenkins"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins?query=true"), (String)"https://somehost/jenkins?query=true"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins/?query=some%20path"), (String)"https://somehost/jenkins?query=some%20path"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins"), (String)"https://user@somehost/jenkins"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/jenkins"), (String)"https://user:password@somehost/jenkins"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"ssh://user:password@somehost:22/path"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"invalid/url"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"ssh://somehost/other/path"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"ssh://somehost/other/path"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/path"), (String)"http://somehost/"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/path"), (String)"http://somehost/path?query=test"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("/var/hg/stuff"), (String)"/var/hg/stuff"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("file:///var/hg/stuff"), (String)"/var/hg/stuff"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("file:/var/hg/stuff"), (String)"/var/hg/stuff"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("/var/hg/stuff"), (String)"file:/var/hg/stuff"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("/var/hg/stuff"), (String)"file:///var/hg/stuff"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("file:///var/hg/stuff"), (String)"file:///var/hg/stuff"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/"), (String)"ssh://somehost/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/"), (String)"http://somehost/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/"), (String)"https://somehost/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost:80/"), (String)"ssh://somehost:22/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost:443/"), (String)"http://somehost:80/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost:22/"), (String)"https://somehost:443/"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("http://somehost/path"), (String)"ssh://somehost/path"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("https://somehost/path"), (String)"http://somehost/path"));
        Assert.assertTrue((boolean)MercurialStatus.looselyMatches((URI)new URI("ssh://somehost/path"), (String)"https://somehost/path"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://scm.foocompany.com/hg/foocomponent/"), (String)"${REPO_URL}"));
        Assert.assertFalse((boolean)MercurialStatus.looselyMatches((URI)new URI("http://scm.foocompany.com/hg/foocomponent/"), (String)"$REPO_URL"));
    }
}

