/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.htmlunit.Page;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.jenkinsci.test.acceptance.docker.DockerClassRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.SleepBuilder;

public class MercurialStatusPermissionTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @ClassRule
    public static DockerClassRule<MercurialContainer> docker = new DockerClassRule(MercurialContainer.class);
    private final String[] names = new String[]{"one1", "two2", "three3"};
    private final String carls = this.names[1];
    private String source;

    @Before
    public void setup() throws Exception {
        this.m.hg("version");
        MercurialContainer container = (MercurialContainer)docker.create();
        Slave slave = container.createSlave(this.j);
        this.m.withNode((Node)slave);
        MercurialInstallation inst = container.createInstallation(this.j, MercurialContainer.Version.HG6, false, false, false, "", slave);
        Assert.assertNotNull((Object)inst);
        this.m.withInstallation(inst);
        FilePath sampleRepo = slave.getRootPath().child("sampleRepo");
        sampleRepo.mkdirs();
        this.m.hg(sampleRepo, "init");
        sampleRepo.child("a").write("a", "UTF-8");
        this.m.hg(sampleRepo, "commit", "--addremove", "--message=a-file");
        this.source = "ssh://test@" + container.ipBound(22) + ":" + container.port(22) + "/" + String.valueOf(sampleRepo);
        FreeStyleProject p = this.j.createFreeStyleProject(this.names[0]);
        p.setScm((SCM)new MercurialSCM(inst.getName(), this.source, null, null, null, null, false));
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.getBuildersList().add((Object)new SleepBuilder(1000L));
        FreeStyleProject carls = p = this.j.createFreeStyleProject(this.names[1]);
        p.setScm((SCM)new MercurialSCM(inst.getName(), this.source, null, null, null, null, false));
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.getBuildersList().add((Object)new SleepBuilder(1000L));
        p = this.j.createFreeStyleProject(this.names[2]);
        p.setScm((SCM)new MercurialSCM(inst.getName(), this.source, null, null, null, null, false));
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.getBuildersList().add((Object)new SleepBuilder(1000L));
        this.j.jenkins.setSecurityRealm((SecurityRealm)this.j.createDummySecurityRealm());
        this.j.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Item.READ}).everywhere().to(new String[]{"bob"}).grant(new Permission[]{Item.READ}).onItems(new Item[]{carls}).to(new String[]{"carl"}).grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"alice"}).grant(new Permission[]{Jenkins.READ}).onRoot().toAuthenticated());
    }

    @Test
    public void testTriggeredWithAnonymous() throws Exception {
        Page page = this.j.createWebClient().goTo("mercurial/notifyCommit?url=" + this.source, "text/plain");
        WebResponse response = page.getWebResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        List headers = response.getResponseHeaders();
        List triggered = headers.stream().filter(nvp -> nvp.getName().equals("Triggered")).collect(Collectors.toList());
        Assert.assertEquals((String)"No headers!", (long)3L, (long)triggered.size());
        List<String> headerValues = triggered.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of a job"));
        MatcherAssert.assertThat((Object)headerValues.toArray(new String[headerValues.size()]), (Matcher)ArrayMatching.hasItemInArray((Matcher)StringContains.containsString((String)"Something")));
        ArrayList<Matcher> testHeaders = new ArrayList<Matcher>();
        for (String name : this.names) {
            MatcherAssert.assertThat((Object)content, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)name)));
            testHeaders.add(IsNot.not((Matcher)StringEndsWith.endsWith((String)(name + "/"))));
        }
        MatcherAssert.assertThat(headerValues, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(testHeaders));
    }

    @Test
    public void testTriggeredWithAllReadable() throws Exception {
        Page page = this.j.createWebClient().login("bob").goTo("mercurial/notifyCommit?url=" + this.source, "text/plain");
        WebResponse response = page.getWebResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        List headers = response.getResponseHeaders();
        List triggered = headers.stream().filter(nvp -> nvp.getName().equals("Triggered")).collect(Collectors.toList());
        Assert.assertEquals((String)"No headers!", (long)3L, (long)triggered.size());
        List<String> headerValues = triggered.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of"));
        MatcherAssert.assertThat((Object)content, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)"Scheduled polling of a job")));
        MatcherAssert.assertThat((Object)headerValues.toArray(new String[headerValues.size()]), (Matcher)IsNot.not((Matcher)ArrayMatching.hasItemInArray((Matcher)StringContains.containsString((String)"Something"))));
        ArrayList<Matcher> testHeaders = new ArrayList<Matcher>();
        for (String name : this.names) {
            MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)name));
            testHeaders.add(StringEndsWith.endsWith((String)(name + "/")));
        }
        MatcherAssert.assertThat(headerValues, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(testHeaders));
    }

    @Test
    public void testTriggeredWithOneReadable() throws Exception {
        Page page = this.j.createWebClient().login("carl").goTo("mercurial/notifyCommit?url=" + this.source, "text/plain");
        WebResponse response = page.getWebResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        List headers = response.getResponseHeaders();
        List triggered = headers.stream().filter(nvp -> nvp.getName().equals("Triggered")).collect(Collectors.toList());
        Assert.assertEquals((String)"No headers!", (long)3L, (long)triggered.size());
        List<String> headerValues = triggered.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of"));
        MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)"Scheduled polling of a job"));
        MatcherAssert.assertThat((Object)headerValues.toArray(new String[headerValues.size()]), (Matcher)ArrayMatching.hasItemInArray((Matcher)StringContains.containsString((String)"Something")));
        ArrayList<Matcher> testHeaders = new ArrayList<Matcher>();
        for (String name : this.names) {
            if (name.equals(this.carls)) {
                MatcherAssert.assertThat((Object)content, (Matcher)StringContains.containsString((String)name));
                testHeaders.add(StringEndsWith.endsWith((String)(name + "/")));
                continue;
            }
            MatcherAssert.assertThat((Object)content, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)name)));
            testHeaders.add(IsNot.not((Matcher)StringEndsWith.endsWith((String)(name + "/"))));
        }
        MatcherAssert.assertThat(headerValues, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(testHeaders));
    }
}

