/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMRevision;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class MercurialSCMSourceTest {
    @ClassRule
    public static JenkinsRule j = new JenkinsRule();
    @ClassRule
    public static MercurialRule m = new MercurialRule(j);
    @ClassRule
    public static TemporaryFolder tmp = new TemporaryFolder();
    private static LogTaskListener listener;
    private static MercurialSCMSource mercurialSCMSource;

    @BeforeClass
    public static void prepareEnvironment() throws Exception {
        String instName = "caching";
        MercurialInstallation installation = new MercurialInstallation(instName, "", "hg", false, true, null, false, null, Collections.emptyList());
        listener = new LogTaskListener(Logger.getLogger(MercurialSCMSourceTest.class.getName()), Level.INFO);
        ((MercurialInstallation.DescriptorImpl)MercurialSCMSourceTest.j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{installation});
        FilePath repo = new FilePath(tmp.getRoot());
        installation.forNode((Node)MercurialSCMSourceTest.j.jenkins, (TaskListener)StreamTaskListener.fromStdout());
        m.hg(repo, "init");
        repo.child("file").write("initial content", "UTF-8");
        m.hg(repo, "commit", "--addremove", "--message=initial");
        m.hg(repo, "tag", "version-1.0");
        m.hg(repo, "branch", "my-branch");
        repo.child("file2").write("content in branch", "UTF-8");
        m.hg(repo, "commit", "--addremove", "--message=branch");
        m.hg(repo, "tag", "version-1.1");
        installation.forNode((Node)MercurialSCMSourceTest.j.jenkins, (TaskListener)StreamTaskListener.fromStdout());
        mercurialSCMSource = new MercurialSCMSource(null, instName, tmp.getRoot().toURI().toURL().toString(), null, null, null, null, null, true);
    }

    @Test
    public void testRetrieveUnknownRevision() throws Exception {
        Assert.assertNull((Object)mercurialSCMSource.fetch("does_not_exist", (TaskListener)listener, null));
    }

    @Test
    public void testRetrieveTag() throws Exception {
        SCMRevision revision = mercurialSCMSource.fetch("version-1.1", (TaskListener)listener, null);
        Assert.assertTrue((boolean)revision.toString().startsWith("my-branch:"));
        revision = mercurialSCMSource.fetch("version-1.0", (TaskListener)listener, null);
        Assert.assertTrue((boolean)revision.toString().startsWith("default:"));
    }

    @Test
    public void testRetrieveBranchTip() throws Exception {
        SCMRevision revision = mercurialSCMSource.fetch("my-branch", (TaskListener)listener, null);
        Assert.assertTrue((boolean)revision.toString().startsWith("my-branch:"));
    }

    @Test
    public void testRetrieveRepoTip() throws Exception {
        SCMRevision revision = mercurialSCMSource.fetch("tip", (TaskListener)listener, null);
        Assert.assertTrue((boolean)revision.toString().startsWith("my-branch:"));
    }
}

